/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.service;

import com.atlassian.confluence.plugins.synchrony.config.SynchronyConfigurationManager;
import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.CspFragment;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;

public class SynchronyURLFragment
implements CspFragment {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int EMPTY_PORT = -1;
    private final SynchronyConfigurationManager synchronyConfigurationManager;

    public SynchronyURLFragment(SynchronyConfigurationManager synchronyConfigurationManager) {
        this.synchronyConfigurationManager = synchronyConfigurationManager;
    }

    public Set<CspDirective> getCSPDirectives() {
        return Set.of(CspDirective.SCRIPT_SRC);
    }

    public Set<URI> getCSPOrigins(CspDirective cspDirective) {
        if (CspDirective.SCRIPT_SRC != cspDirective) {
            return Set.of();
        }
        String synchronyServiceUrl = this.synchronyConfigurationManager.getExternalServiceUrl();
        try {
            URI canonicalSynchronyServiceUrl = this.getCanonicalUrl(synchronyServiceUrl);
            return Set.of(canonicalSynchronyServiceUrl);
        }
        catch (Exception e) {
            return Set.of();
        }
    }

    private URI getCanonicalUrl(String httpRequestUrl) throws URISyntaxException {
        if (httpRequestUrl == null || httpRequestUrl.isEmpty()) {
            throw new URISyntaxException("Request URL is null or empty", "Cannot determine base URL");
        }
        URI requestURL = new URI(httpRequestUrl);
        if (requestURL.getScheme() == null || requestURL.getHost() == null) {
            throw new URISyntaxException(httpRequestUrl, "Invalid URL: Scheme or host is missing");
        }
        StringBuilder baseUrlBuilder = new StringBuilder(requestURL.getScheme());
        baseUrlBuilder.append("://");
        baseUrlBuilder.append(requestURL.getHost());
        if (!Set.of(Integer.valueOf(-1), Integer.valueOf(80), Integer.valueOf(443)).contains(requestURL.getPort())) {
            baseUrlBuilder.append(":").append(requestURL.getPort());
        }
        return new URI(baseUrlBuilder.toString());
    }

    public Set<String> getUrlPatterns() {
        return Set.of("/**");
    }
}

