/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.service;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="synchrony-uuid-manager")
@ExportAsService(value={LifecycleAware.class})
public class SynchronyUUIDManager
implements LifecycleAware {
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final String SYNCHRONY_COLLABORATIVE_EDITOR_UUID = "synchrony_collaborative_editor_UUID";

    @Autowired
    public SynchronyUUIDManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void onStart() {
        this.setNewGlobalUuid();
    }

    public void onStop() {
    }

    String getGlobalUuid() {
        String globalUuid = (String)this.pluginSettingsFactory.createGlobalSettings().get(SYNCHRONY_COLLABORATIVE_EDITOR_UUID);
        if (globalUuid == null) {
            globalUuid = this.setNewGlobalUuid();
        }
        return globalUuid;
    }

    private String setNewGlobalUuid() {
        String newUuid = UUID.randomUUID().toString();
        this.pluginSettingsFactory.createGlobalSettings().put(SYNCHRONY_COLLABORATIVE_EDITOR_UUID, (Object)newUuid);
        return newUuid;
    }
}

