/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.service.http;

import com.atlassian.confluence.plugins.synchrony.model.SynchronyError;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class LockingResponseHandler
implements ResponseHandler<Optional<SynchronyError.Code>> {
    public Optional<SynchronyError.Code> handleResponse(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            return Optional.empty();
        }
        Map body = this.getBody(response);
        return Optional.of(SynchronyError.Code.from((String)body.get("type")));
    }

    private Map getBody(HttpResponse response) throws IOException {
        ObjectMapper objectMapper = new DefaultObjectMapperProvider().getObjectMapper();
        return (Map)objectMapper.readValue(response.getEntity().getContent(), Map.class);
    }
}

