/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.synchrony.service.http;

import com.atlassian.confluence.plugins.synchrony.events.SynchronyExternalChangesErrorEvent;
import com.atlassian.confluence.plugins.synchrony.model.SynchronyError;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronyResponseHandler
implements ResponseHandler<Either<SynchronyError, JSONObject>> {
    private static final Logger log = LoggerFactory.getLogger(SynchronyResponseHandler.class);
    private final long id;
    private final JSONObject data;
    private final EventPublisher eventPublisher;

    public SynchronyResponseHandler(long id, JSONObject data, @ComponentImport EventPublisher eventPublisher) {
        this.id = id;
        this.data = data;
        this.eventPublisher = eventPublisher;
    }

    public Either<SynchronyError, JSONObject> handleResponse(HttpResponse response) throws IOException {
        JSONObject result = this.getResult(response);
        int status = response.getStatusLine().getStatusCode();
        if (status == 200 && result.containsKey((Object)"rev")) {
            return Either.right((Object)result);
        }
        return Either.left((Object)this.failed(status, result));
    }

    private JSONObject getResult(HttpResponse response) throws IOException {
        String charset = this.getResponseContentType(response).getCharset().name();
        JSONObject result = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(response.getEntity().getContent(), charset));
        if (result == null) {
            result = new JSONObject((Map)ImmutableMap.of((Object)"message", (Object)"No result returned"));
        }
        return result;
    }

    private ContentType getResponseContentType(HttpResponse response) {
        ContentType resContentType = ContentType.get((HttpEntity)response.getEntity());
        if (resContentType == null) {
            resContentType = ContentType.APPLICATION_JSON;
        }
        return resContentType;
    }

    private SynchronyError failed(int status, JSONObject result) {
        this.eventPublisher.publish((Object)new SynchronyExternalChangesErrorEvent(status, result.get((Object)"message").toString(), this.id, (String)this.data.get((Object)"ancestor")));
        log.warn(this.getMessage(result, status));
        SynchronyError.Code synchronyCode = SynchronyError.Code.from((String)result.get((Object)"type"));
        return new SynchronyError(synchronyCode, (String)result.get((Object)"conflicting-rev"));
    }

    private String getMessage(JSONObject result, int status) {
        JSONObject meta;
        JSONObject master;
        JSONObject filteredMerges = new JSONObject();
        JSONObject merges = (JSONObject)this.data.get((Object)"merges");
        if (merges != null && (master = (JSONObject)merges.get((Object)"master")) != null && (meta = (JSONObject)master.get((Object)"meta")) != null) {
            filteredMerges.put((Object)"type", meta.get((Object)"type"));
            filteredMerges.put((Object)"trigger", meta.get((Object)"trigger"));
            filteredMerges.put((Object)"confVersion", meta.get((Object)"confVersion"));
        }
        return "Synchrony external changes API call returned " + status + ": " + result.toJSONString() + " content-id: " + this.id + " rev: " + String.valueOf(this.data.get((Object)"rev")) + " ancestor: " + String.valueOf(this.data.get((Object)"ancestor")) + " merges: " + String.valueOf(filteredMerges) + " generate-rev: " + String.valueOf(this.data.get((Object)"generate-rev")) + " generate-reset: " + String.valueOf(this.data.get((Object)"generate-reset"));
    }
}

