/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.authentication;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

enum AccessType {
    EMPTY(new Class[0]),
    SYSTEM_ADMIN_ONLY(SystemAdminOnly.class, com.atlassian.annotations.security.SystemAdminOnly.class),
    ADMIN_ONLY(AdminOnly.class, com.atlassian.annotations.security.AdminOnly.class),
    LICENSED_ONLY(LicensedOnly.class, com.atlassian.annotations.security.LicensedOnly.class),
    UNLICENSED_SITE_ACCESS(UnlicensedSiteAccess.class, com.atlassian.annotations.security.UnlicensedSiteAccess.class),
    ANONYMOUS_SITE_ACCESS(AnonymousSiteAccess.class, com.atlassian.annotations.security.AnonymousSiteAccess.class),
    UNRESTRICTED_ACCESS(com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess.class, UnrestrictedAccess.class);

    private static final Map<String, AccessType> VALID_ANNOTATIONS;
    private final Class<? extends Annotation>[] annotationTypes;

    @SafeVarargs
    private AccessType(Class<? extends Annotation> ... annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    static AccessType getAccessType(Class<?> clazz, Method method) {
        Package packageElement = clazz != null ? clazz.getPackage() : null;
        return Stream.of(method, clazz, packageElement).filter(Objects::nonNull).map(AccessType::extractFromAnnotation).filter(Objects::nonNull).findFirst().orElse(EMPTY);
    }

    private static AccessType extractFromAnnotation(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
            String annotationType = annotation.annotationType().getName();
            if (!VALID_ANNOTATIONS.containsKey(annotationType)) continue;
            return VALID_ANNOTATIONS.get(annotationType);
        }
        return null;
    }

    static {
        VALID_ANNOTATIONS = Arrays.stream(AccessType.values()).filter(accessType -> accessType.annotationTypes != null).flatMap(accessType -> Arrays.stream(accessType.annotationTypes).map(annotationType -> Pair.of((Object)annotationType.getName(), (Object)accessType))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }
}

