/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.xml;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.module.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Internal
public class ComplementingElement
implements Element {
    private final Element baseElement;
    private final Map<String, String> attributes;
    private final LeafElement childElement;
    private final String childElementName;

    public ComplementingElement(Element element, Map<String, String> attributes, String childElementName, String childElementValue) {
        this.baseElement = element;
        this.attributes = attributes;
        this.childElement = new LeafElement(childElementName, childElementValue);
        this.childElementName = childElementName;
    }

    public String attributeValue(String s) {
        return this.attributes.getOrDefault(s, this.baseElement.attributeValue(s));
    }

    public String attributeValue(String s, String s1) {
        return this.attributes.getOrDefault(s, this.baseElement.attributeValue(s, s1));
    }

    public Element element(String s) {
        return this.childElementName.equals(s) ? this.childElement : this.baseElement.element(s);
    }

    public List<Element> elements(String s) {
        return this.childElementName.equals(s) ? List.of(this.childElement) : this.baseElement.elements(s);
    }

    public String getTextTrim() {
        return this.baseElement.getTextTrim();
    }

    public String elementTextTrim(String s) {
        return this.baseElement.elementTextTrim(s);
    }

    public String getText() {
        return this.baseElement.getText();
    }

    public String getName() {
        return this.baseElement.getName();
    }

    public List<Element> elements() {
        ArrayList<Element> list = new ArrayList<Element>(this.baseElement.elements());
        list.add(this.childElement);
        return list;
    }

    public List<String> attributeNames() {
        ArrayList<String> list = new ArrayList<String>(this.baseElement.attributeNames());
        list.addAll(this.attributes.keySet());
        return list;
    }

    private static class LeafElement
    implements Element {
        private final String value;
        private final String name;

        public LeafElement(String childElementName, String childElementValue) {
            this.name = childElementName;
            this.value = childElementValue;
        }

        public String getText() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getTextTrim() {
            return this.value == null ? null : this.value.trim();
        }

        public String attributeValue(String s) {
            return null;
        }

        public String attributeValue(String s, String s1) {
            return null;
        }

        public Element element(String s) {
            return null;
        }

        public List<Element> elements(String s) {
            return Collections.emptyList();
        }

        public String elementTextTrim(String s) {
            return null;
        }

        public List<Element> elements() {
            return null;
        }

        public List<String> attributeNames() {
            return null;
        }
    }
}

