/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.common.renderer;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.common.renderer.ActivityObjectRenderer;
import com.atlassian.streams.common.renderer.AuthorsRenderer;
import com.atlassian.streams.common.renderer.CommentRenderer;
import com.atlassian.streams.common.renderer.CompoundStatementRenderer;
import com.atlassian.streams.common.renderer.TitleRenderer;
import com.atlassian.streams.spi.StreamsI18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nullable;

public class StreamsEntryRendererFactoryImpl
implements StreamsEntryRendererFactory {
    private final I18nResolver i18nResolver;
    private final TemplateRenderer templateRenderer;

    public StreamsEntryRendererFactoryImpl(StreamsI18nResolver i18nResolver, TemplateRenderer templateRenderer) {
        this.i18nResolver = i18nResolver;
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
    }

    public StreamsEntry.Renderer newCommentRenderer(String comment) {
        return this.newCommentRenderer(this.newCommentTitleRendererFunc(), comment);
    }

    public StreamsEntry.Renderer newCommentRenderer(Html comment) {
        return this.newCommentRenderer(this.newCommentTitleRendererFunc(), comment);
    }

    public StreamsEntry.Renderer newCommentRenderer(Function<StreamsEntry, Html> titleRenderer, String message) {
        return new CommentRenderer(this.templateRenderer, titleRenderer, message);
    }

    public StreamsEntry.Renderer newCommentRenderer(Function<StreamsEntry, Html> titleRenderer, Html message) {
        return this.newCommentRenderer(titleRenderer, message, null);
    }

    public StreamsEntry.Renderer newCommentRenderer(Function<StreamsEntry, Html> titleRenderer, Html apply, @Nullable URI styleLink) {
        return new CommentRenderer(this.templateRenderer, titleRenderer, apply, (Option<URI>)Option.option((Object)styleLink));
    }

    public Function<StreamsEntry, Html> newTitleRendererFunc(String key) {
        return this.newTitleRendererFunc(key, this.newAuthorsRendererFunc(), this.newActivityObjectsRendererFunc(), this.newActivityObjectRendererWithSummaryFunc());
    }

    public Function<StreamsEntry, Html> newTitleRendererFunc(String key, Function<Iterable<UserProfile>, Html> authorsRenderer, @Nullable Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> activityObjectRenderer, @Nullable Function<StreamsEntry.ActivityObject, Option<Html>> targetRenderer) {
        return new TitleRenderer(this.i18nResolver, key, authorsRenderer, activityObjectRenderer, targetRenderer);
    }

    public Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> newActivityObjectsRendererFunc() {
        return this.newActivityObjectsRendererFunc(this.newActivityObjectRendererWithSummaryFunc());
    }

    public Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> newActivityObjectsRendererFunc(Function<StreamsEntry.ActivityObject, Option<Html>> objectRenderer) {
        return new CompoundStatementRenderer<StreamsEntry.ActivityObject>(this.i18nResolver, objectRenderer);
    }

    public Function<Iterable<UserProfile>, Html> newAuthorsRendererFunc() {
        return new AuthorsRenderer(this.i18nResolver, this.templateRenderer, true);
    }

    public Function<Iterable<UserProfile>, Html> newUserProfileRendererFunc() {
        return new AuthorsRenderer(this.i18nResolver, this.templateRenderer, false);
    }

    public Function<StreamsEntry.ActivityObject, Option<Html>> newActivityObjectRendererWithSummaryFunc() {
        return new ActivityObjectRenderer(this.templateRenderer, true);
    }

    public Function<StreamsEntry.ActivityObject, Option<Html>> newActivityObjectRendererWithoutSummaryFunc() {
        return new ActivityObjectRenderer(this.templateRenderer, false);
    }

    public <T> Function<Iterable<T>, Option<Html>> newCompoundStatementRendererFunc(Function<T, Option<Html>> render) {
        return new CompoundStatementRenderer<T>(this.i18nResolver, render);
    }

    public Function<StreamsEntry, Html> newCommentTitleRendererFunc() {
        return CommentRenderer.standardTitleRenderer(this);
    }
}

