/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.common.spring;

import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.osgi.bridge.external.SpringHostContainer;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.FeedContentSanitizer;
import com.atlassian.streams.api.builder.StreamsFeedUriBuilderFactory;
import com.atlassian.streams.api.renderer.StreamsEntryRendererFactory;
import com.atlassian.streams.common.SwitchingSessionManager;
import com.atlassian.streams.common.module.ActivityProviderModuleDescriptorFactory;
import com.atlassian.streams.spi.DelegatingSessionManager;
import com.atlassian.streams.spi.StreamsI18nResolver;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ExportBeans {
    @Bean
    HostContainer springHostContainer() {
        return new SpringHostContainer();
    }

    @Bean
    ListableModuleDescriptorFactory activityProviderModuleDescriptorFactory(HostContainer hostContainer) {
        return new ActivityProviderModuleDescriptorFactory(hostContainer);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportActivityStreamsProviderModule(ListableModuleDescriptorFactory activityProviderModuleDescriptorFactory) {
        return OsgiServices.exportAsModuleType(activityProviderModuleDescriptorFactory);
    }

    @Bean
    FactoryBean<ServiceRegistration> exportStreamsI18nResolver(StreamsI18nResolver streamsI18nResolver) {
        return OsgiServices.exportOsgiService(streamsI18nResolver, ExportOptions.as(I18nResolver.class, StreamsI18nResolver.class));
    }

    @Bean
    FactoryBean<ServiceRegistration> exportStreamsEntryRendererFactory(StreamsEntryRendererFactory streamsEntryRendererFactory) {
        return OsgiServices.exportOsgiService(streamsEntryRendererFactory, ExportOptions.as(StreamsEntryRendererFactory.class, new Class[0]));
    }

    @Bean
    FactoryBean<ServiceRegistration> exportStreamsFeedUriBuilderFactory(StreamsFeedUriBuilderFactory streamsFeedUriBuilderFactory) {
        return OsgiServices.exportOsgiService(streamsFeedUriBuilderFactory, ExportOptions.as(StreamsFeedUriBuilderFactory.class, new Class[0]));
    }

    @Bean
    FactoryBean<ServiceRegistration> exportFeedSanitizer(FeedContentSanitizer feedSanitizer) {
        return OsgiServices.exportOsgiService(feedSanitizer, ExportOptions.as(FeedContentSanitizer.class, new Class[0]));
    }

    @Bean
    FactoryBean<ServiceRegistration> exportSessionManager(SwitchingSessionManager sessionManager) {
        return OsgiServices.exportOsgiService((Object)sessionManager, ExportOptions.as(DelegatingSessionManager.class, new Class[0]));
    }
}

