/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import org.apache.batik.css.parser.CSSSACMediaList;
import org.apache.batik.css.parser.Parser;
import org.owasp.validator.css.media.CssMediaFeature;
import org.owasp.validator.css.media.CssMediaQuery;
import org.owasp.validator.css.media.CssMediaQueryList;
import org.owasp.validator.css.media.CssMediaQueryLogicalOperator;
import org.owasp.validator.css.media.CssMediaType;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.LexicalUnit;

public class CssParser
extends Parser {
    @Override
    protected void parseStyleDeclaration(boolean inSheet) throws CSSException {
        boolean leadingDash = false;
        block9: while (true) {
            switch (this.current) {
                case 0: {
                    if (inSheet) {
                        throw this.createCSSParseException("eof");
                    }
                    return;
                }
                case 2: {
                    if (!inSheet) {
                        throw this.createCSSParseException("eof.expected");
                    }
                    this.nextIgnoreSpaces();
                    return;
                }
                case 8: {
                    this.nextIgnoreSpaces();
                    continue block9;
                }
                case 5: {
                    leadingDash = true;
                    this.next();
                    break;
                }
                default: {
                    throw this.createCSSParseException("identifier");
                }
                case 20: 
            }
            String name = (leadingDash ? "-" : "") + this.scanner.getStringValue();
            leadingDash = false;
            if (this.nextIgnoreSpaces() != 16) {
                throw this.createCSSParseException("colon");
            }
            this.nextIgnoreSpaces();
            LexicalUnit exp = null;
            try {
                exp = this.parseExpression(false);
            }
            catch (CSSParseException e) {
                this.reportError(e);
            }
            if (exp == null) continue;
            boolean important = false;
            if (this.current == 23) {
                important = true;
                this.nextIgnoreSpaces();
            }
            this.documentHandler.property(name, exp, important);
        }
    }

    @Override
    protected CSSSACMediaList parseMediaList() {
        CssMediaQueryList mediaList = new CssMediaQueryList();
        mediaList.append(this.parseMediaQuery());
        while (this.hasAnotherMediaQuery()) {
            this.nextIgnoreSpaces();
            mediaList.append(this.parseMediaQuery());
        }
        return mediaList;
    }

    private boolean hasAnotherMediaQuery() {
        return this.current == 6 || this.current == 20 && this.scanner.getStringValue().equals(CssMediaQueryLogicalOperator.OR.toString());
    }

    protected CssMediaQuery parseMediaQuery() {
        CssMediaQuery query = new CssMediaQuery();
        CssMediaType mediaType = null;
        CssMediaQueryLogicalOperator logicalOperator = null;
        block0 : switch (this.current) {
            case 14: {
                mediaType = CssMediaType.IMPLIED_ALL;
                break;
            }
            case 20: {
                logicalOperator = CssMediaQueryLogicalOperator.parse(this.scanner.getStringValue());
                if (logicalOperator != null) {
                    switch (logicalOperator) {
                        case ONLY: {
                            this.parseLogicalOperatorOnly();
                            mediaType = this.parseMediaType();
                            break block0;
                        }
                        case NOT: {
                            mediaType = this.parseLogicalOperatorNot();
                            break block0;
                        }
                        case AND: 
                        case OR: 
                        case COMMA: {
                            throw this.createCSSParseException("identifier");
                        }
                    }
                    break;
                }
                mediaType = this.parseMediaType();
                break;
            }
            default: {
                throw this.createCSSParseException("identifier");
            }
        }
        query.setMediaType(mediaType);
        query.setLogicalOperator(logicalOperator);
        if (mediaType == CssMediaType.IMPLIED_ALL) {
            query.addMediaFeature(this.parseMediaFeature());
        }
        while (this.current == 20 && CssMediaQueryLogicalOperator.parse(this.scanner.getStringValue()) == CssMediaQueryLogicalOperator.AND) {
            this.nextIgnoreSpaces();
            query.addMediaFeature(this.parseMediaFeature());
        }
        return query;
    }

    private CssMediaType parseMediaType() {
        CssMediaType mediaType = CssMediaType.parse(this.scanner.getStringValue());
        if (mediaType == null) {
            throw this.createCSSParseException("identifier");
        }
        this.nextIgnoreSpaces();
        return mediaType;
    }

    private CssMediaType parseLogicalOperatorNot() {
        CssMediaType mediaType = this.nextIgnoreSpaces() == 20 ? this.parseMediaType() : CssMediaType.IMPLIED_ALL;
        return mediaType;
    }

    private void parseLogicalOperatorOnly() {
        if (this.nextIgnoreSpaces() != 20) {
            throw this.createCSSParseException("identifier");
        }
    }

    protected CssMediaFeature parseMediaFeature() {
        if (this.current != 14) {
            throw this.createCSSParseException("'(' expected.");
        }
        this.nextIgnoreSpaces();
        String namePrefix = "";
        if (this.current == 5) {
            this.nextIgnoreSpaces();
            namePrefix = "-";
        }
        if (this.current != 20) {
            throw this.createCSSParseException("identifier");
        }
        String name = namePrefix + this.scanner.getStringValue();
        this.nextIgnoreSpaces();
        LexicalUnit exp = null;
        if (this.current == 16) {
            this.nextIgnoreSpaces();
            exp = this.parseTerm(null);
        }
        if (this.current != 15) {
            throw this.createCSSParseException("')' expected.");
        }
        this.nextIgnoreSpaces();
        return new CssMediaFeature(name, exp);
    }

    @Override
    protected void parseMediaRule() {
        CSSSACMediaList ml = this.parseMediaList();
        try {
            this.documentHandler.startMedia(ml);
            if (this.current != 1) {
                this.reportError("left.curly.brace");
            } else {
                this.nextIgnoreSpaces();
                block6: while (true) {
                    switch (this.current) {
                        case 0: 
                        case 2: {
                            break block6;
                        }
                        default: {
                            this.parseRuleSet();
                            continue block6;
                        }
                    }
                    break;
                }
                this.nextIgnoreSpaces();
            }
        }
        finally {
            this.documentHandler.endMedia(ml);
        }
    }
}

