/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.owasp.validator.html.InternalPolicy;
import org.owasp.validator.html.TagMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ASHTMLSerializer
extends HTMLSerializer {
    private static final Logger logger = LoggerFactory.getLogger(ASHTMLSerializer.class);
    private boolean encodeAllPossibleEntities;
    private final TagMatcher allowedEmptyTags;
    private final TagMatcher requireClosingTags;

    public ASHTMLSerializer(Writer w, OutputFormat format, InternalPolicy policy) {
        super(w, format);
        this.allowedEmptyTags = policy.getAllowedEmptyTags();
        this.requireClosingTags = policy.getRequiresClosingTags();
        this.encodeAllPossibleEntities = policy.isEntityEncodeIntlCharacters();
    }

    protected String getEntityRef(int charToPrint) {
        if (this.encodeAllPossibleEntities || "<>\"'&".indexOf(charToPrint) != -1) {
            return super.getEntityRef(charToPrint);
        }
        return null;
    }

    protected void serializeElement(Element elem) throws IOException {
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean preserveSpace = state.preserveSpace;
        this._printer.printText('<');
        this._printer.printText(tagName);
        this._printer.indent();
        NamedNodeMap attrMap = elem.getAttributes();
        if (attrMap != null) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                String name = attr.getName().toLowerCase(Locale.ENGLISH);
                String value = attr.getValue();
                if (!attr.getSpecified()) continue;
                this._printer.printSpace();
                if (value == null) {
                    value = "";
                }
                if (!this._format.getPreserveEmptyAttributes() && value.length() == 0) {
                    this._printer.printText(name);
                    continue;
                }
                if (HTMLdtd.isURI((String)tagName, (String)name)) {
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this._printer.printText(this.escapeURI(value));
                    this._printer.printText('\"');
                    continue;
                }
                if (HTMLdtd.isBoolean((String)tagName, (String)name)) {
                    this._printer.printText(name);
                    continue;
                }
                this._printer.printText(name);
                this._printer.printText("=\"");
                this.printEscaped(value);
                this._printer.printText('\"');
            }
        }
        if (HTMLdtd.isPreserveSpace((String)tagName)) {
            preserveSpace = true;
        }
        if (elem.hasChildNodes() || !HTMLdtd.isEmptyTag((String)tagName)) {
            state = this.enterElementState(null, null, tagName, preserveSpace);
            if (tagName.equalsIgnoreCase("A") || tagName.equalsIgnoreCase("TD")) {
                state.empty = false;
                this._printer.printText('>');
            }
            if (tagName.equalsIgnoreCase("SCRIPT") || tagName.equalsIgnoreCase("STYLE")) {
                state.unescaped = true;
            }
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.serializeNode(child);
            }
            this.endElementIO(null, null, tagName);
        } else {
            this._printer.unindent();
            if (!elem.hasChildNodes() && this.isAllowedEmptyTag(tagName) && !this.requiresClosingTag(tagName)) {
                this._printer.printText("/>");
            } else {
                this._printer.printText('>');
            }
            state.afterElement = true;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty && this.isAllowedEmptyTag(rawName) && !this.requiresClosingTag(rawName)) {
            this._printer.printText("/>");
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (rawName == null || !HTMLdtd.isOnlyOpening((String)rawName) || HTMLdtd.isOptionalClosing((String)rawName)) {
                if (this._indenting && !state.preserveSpace && state.afterElement) {
                    this._printer.breakLine();
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(state.rawName);
                this._printer.printText('>');
            }
        }
        state = this.leaveElementState();
        if (rawName == null || !rawName.equalsIgnoreCase("A") && !rawName.equalsIgnoreCase("TD")) {
            state.afterElement = true;
        }
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    protected String escapeURI(String uri) {
        try {
            this.printEscaped(uri);
        }
        catch (IOException e) {
            logger.error("URI escaping failed for value: " + uri);
        }
        return "";
    }

    private boolean requiresClosingTag(String tagName) {
        return this.requireClosingTags.matches(tagName);
    }

    private boolean isAllowedEmptyTag(String tagName) {
        return "head".equals(tagName) || this.allowedEmptyTags.matches(tagName);
    }
}

