/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.analytics.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.event.analytics.PasswordPolicyConfigurationAnalyticsEventBase;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class PasswordPolicyEcAnalyticsEvent
extends PasswordPolicyConfigurationAnalyticsEventBase {
    private PasswordPolicyEcAnalyticsEvent(long directoryId, String preset, Integer minimumLength, Integer minimumLowercase, Integer minimumUppercase, Integer minimumDigits, Integer minimumSpecialCharacters, Integer minimumRulesMatched) {
        super(directoryId, preset, minimumLength, minimumLowercase, minimumUppercase, minimumDigits, minimumSpecialCharacters, minimumRulesMatched);
    }

    @EventName
    public String getEventName() {
        return super.eventName();
    }

    public static Builder builder(long directoryId) {
        return new Builder().directoryId(directoryId);
    }

    public static class Builder {
        private long directoryId;
        private String preset;
        private Integer minimumLength;
        private Integer minimumLowercase;
        private Integer minimumUppercase;
        private Integer minimumDigits;
        private Integer minimumSpecialCharacters;
        private Integer minimumRulesMatched;

        private Builder() {
        }

        public Builder directoryId(long directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public Builder configuration(@Nullable PasswordPolicyConfiguration configuration) {
            if (configuration != null) {
                this.preset = Optional.ofNullable(configuration.getPreset()).map(Enum::name).orElse(null);
                this.minimumLength = configuration.getMinimumLength();
                this.minimumLowercase = configuration.getMinimumLowercase();
                this.minimumUppercase = configuration.getMinimumUppercase();
                this.minimumDigits = configuration.getMinimumDigits();
                this.minimumSpecialCharacters = configuration.getMinimumSpecialCharacters();
                this.minimumRulesMatched = configuration.getMinimumRulesMatched();
            }
            return this;
        }

        public PasswordPolicyEcAnalyticsEvent build() {
            return new PasswordPolicyEcAnalyticsEvent(this.directoryId, this.preset, this.minimumLength, this.minimumLowercase, this.minimumUppercase, this.minimumDigits, this.minimumSpecialCharacters, this.minimumRulesMatched);
        }
    }
}

