/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.analytics.scheduler;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.crowd.common.analytics.statistics.collectors.StatisticsCollector;
import com.atlassian.crowd.embedded.admin.util.EmbeddedCrowdSystemProperties;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractStatisticsCollectionService
implements JobRunner,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStatisticsCollectionService.class);
    @VisibleForTesting
    static final String COLLECTION_SCHEDULE = "0 0 23 * * ?";
    @VisibleForTesting
    static final String DEBUG_COLLECTION_SCHEDULE = "0/30 * * * * ?";
    protected final SchedulerService schedulerService;
    protected final EventPublisher eventPublisher;
    protected final Collection<StatisticsCollector<?>> collectors;

    protected AbstractStatisticsCollectionService(EventPublisher eventPublisher, SchedulerService schedulerService, Collection<StatisticsCollector<?>> collectors) {
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
        this.collectors = (Collection)collectors.stream().filter(this::shouldApplyCollector).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    protected abstract RunMode getRunMode();

    protected abstract JobId getJobId();

    public void afterPropertiesSet() {
        if (((Boolean)EmbeddedCrowdSystemProperties.Analytics.ENABLED.getValue()).booleanValue()) {
            this.registerScheduledJob();
        }
    }

    public void destroy() {
        this.schedulerService.unregisterJobRunner(this.getJobRunnerKey());
        LOG.debug("Unregistered analytics collection job");
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        LOG.debug("Collecting instance statistics");
        this.collectors.forEach(this::publishEvents);
        LOG.debug("Done collecting instance statistics");
        return JobRunnerResponse.success();
    }

    protected JobRunnerKey getJobRunnerKey() {
        return JobRunnerKey.of((String)this.getClass().getCanonicalName());
    }

    private void registerScheduledJob() {
        try {
            Class.forName("com.atlassian.analytics.api.annotations.EventName");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No analytics api, not registering analytics collection");
            return;
        }
        try {
            this.schedulerService.registerJobRunner(this.getJobRunnerKey(), (JobRunner)this);
            String collectionSchedule = AbstractStatisticsCollectionService.getCollectionSchedule();
            this.schedulerService.scheduleJob(this.getJobId(), JobConfig.forJobRunnerKey((JobRunnerKey)this.getJobRunnerKey()).withSchedule(Schedule.forCronExpression((String)collectionSchedule)).withRunMode(this.getRunMode()));
            LOG.debug("Registered analytics collection job with schedule {}", (Object)collectionSchedule);
        }
        catch (Exception ex) {
            LOG.warn("Failed to register analytics collection job", (Throwable)ex);
        }
    }

    @VisibleForTesting
    static String getCollectionSchedule() {
        return (Boolean)EmbeddedCrowdSystemProperties.Analytics.DEBUG_SCHEDULE_ENABLED.getValue() != false ? DEBUG_COLLECTION_SCHEDULE : COLLECTION_SCHEDULE;
    }

    private void publishEvents(StatisticsCollector<?> collector) {
        try {
            collector.collect().forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
        }
        catch (Exception e) {
            LOG.warn("Failed to collect analytics for " + String.valueOf(collector), (Throwable)e);
        }
    }

    private boolean shouldApplyCollector(StatisticsCollector<?> collector) {
        boolean isPerNodeJob = this.getRunMode() == RunMode.RUN_LOCALLY;
        return isPerNodeJob == collector.isPerNodeCollector();
    }
}

