/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.azuread;

import com.atlassian.crowd.embedded.admin.azuread.AzureAdDirectoryConfiguration;
import com.atlassian.crowd.embedded.validator.impl.CrowdCronExpressionValidator;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class AzureAdConfigurationValidator
implements Validator {
    public static final String INVALID = "invalid";
    public static final String REQUIRED = "required";

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(AzureAdDirectoryConfiguration.class);
    }

    public void validate(Object target, Errors errors) {
        AzureAdDirectoryConfiguration configuration = (AzureAdDirectoryConfiguration)target;
        if (configuration.getDirectoryId() == 0L && StringUtils.isBlank((CharSequence)configuration.getWebAppSecret())) {
            errors.rejectValue("webAppSecret", REQUIRED);
        }
        if (configuration.getRegion().equals("CUSTOM")) {
            if (AzureAdConfigurationValidator.isInvalidURL(configuration.getGraphEndpoint())) {
                errors.rejectValue("graphEndpoint", INVALID);
            }
            if (AzureAdConfigurationValidator.isInvalidURL(configuration.getAuthorityEndpoint())) {
                errors.rejectValue("authorityEndpoint", INVALID);
            }
        }
        if (configuration.isCronExpressionType() && !CrowdCronExpressionValidator.isValid((String)configuration.getCronExpression())) {
            errors.rejectValue("cronExpression", INVALID);
        }
    }

    public static boolean isInvalidURL(String url) {
        try {
            new URL(url);
            return false;
        }
        catch (MalformedURLException e) {
            return true;
        }
    }
}

