/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.azuread;

import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.monitor.poller.PollerConfig;
import com.atlassian.crowd.directory.rest.endpoint.DefaultRegion;
import com.atlassian.crowd.directory.synchronisation.Defaults;
import com.atlassian.crowd.embedded.admin.util.ConfigurationWithPassword;
import com.atlassian.crowd.embedded.api.OperationType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AzureAdDirectoryConfiguration
implements ConfigurationWithPassword {
    public static final String CUSTOM_REGION = "CUSTOM";
    protected long directoryId;
    protected boolean active = true;
    protected String name;
    protected Set<String> filteredGroupNames = Collections.emptySet();
    protected boolean groupFilteringEnabled;
    private SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncOnAuthMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.DEFAULT;
    private String region = DefaultRegion.GLOBAL.name();
    private String graphEndpoint;
    private String authorityEndpoint;
    private String webAppId;
    private String webAppSecret;
    private String nativeAppId;
    private String tenantId;
    private boolean useNestedGroups;
    private boolean localGroupsEnabled;
    private boolean incrementalSyncEnabled = true;
    private PollerConfig pollerConfig = new PollerConfig();
    private Duration readTimeoutInSec = Defaults.READ_TIMEOUT;
    private Duration connectionTimeoutInSec = Defaults.CONNECTION_TIMEOUT;
    private final Set<OperationType> permissions = new HashSet<OperationType>();

    @Override
    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long ID) {
        this.directoryId = ID;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGroupFilteringEnabled() {
        return this.groupFilteringEnabled && !this.filteredGroupNames.isEmpty();
    }

    public void setGroupFilteringEnabled(boolean groupFilteringEnabled) {
        this.groupFilteringEnabled = groupFilteringEnabled;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        for (DefaultRegion value : DefaultRegion.values()) {
            if (!value.name().equals(region) && !CUSTOM_REGION.equals(region)) continue;
            this.region = region;
            break;
        }
    }

    public String getGraphEndpoint() {
        return this.graphEndpoint;
    }

    public void setGraphEndpoint(String graphEndpoint) {
        this.graphEndpoint = graphEndpoint;
    }

    public String getAuthorityEndpoint() {
        return this.authorityEndpoint;
    }

    public void setAuthorityEndpoint(String authorityEndpoint) {
        this.authorityEndpoint = authorityEndpoint;
    }

    public String getWebAppId() {
        return this.webAppId;
    }

    public String getWebAppSecret() {
        return this.webAppSecret;
    }

    public void setWebAppSecret(String webAppSecret) {
        this.webAppSecret = webAppSecret;
    }

    public void setWebAppId(String webAppId) {
        this.webAppId = webAppId;
    }

    public String getNativeAppId() {
        return this.nativeAppId;
    }

    public void setNativeAppId(String nativeAppId) {
        this.nativeAppId = nativeAppId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isUseNestedGroups() {
        return this.useNestedGroups;
    }

    public void setUseNestedGroups(boolean useNestedGroups) {
        this.useNestedGroups = useNestedGroups;
    }

    public boolean isLocalGroupsEnabled() {
        return this.localGroupsEnabled;
    }

    public void setLocalGroupsEnabled(boolean localGroupsEnabled) {
        this.localGroupsEnabled = localGroupsEnabled;
    }

    public boolean isIncrementalSyncEnabled() {
        return this.incrementalSyncEnabled;
    }

    public void setIncrementalSyncEnabled(boolean incrementalSyncEnabled) {
        this.incrementalSyncEnabled = incrementalSyncEnabled;
    }

    public PollerConfig getPollerConfig() {
        return this.pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.pollerConfig = pollerConfig;
    }

    public void setReadTimeoutInSec(Duration readTimeoutInSec) {
        this.readTimeoutInSec = readTimeoutInSec;
    }

    public void setConnectionTimeoutInSec(Duration connectionTimeoutInSec) {
        this.connectionTimeoutInSec = connectionTimeoutInSec;
    }

    public String getFilteredGroupNames() {
        return new ArrayList<String>(this.filteredGroupNames).stream().sorted().collect(Collectors.joining("\n"));
    }

    public Set<String> getFilteredGroupNamesAsSet() {
        return this.isGroupFilteringEnabled() ? this.filteredGroupNames : Collections.emptySet();
    }

    public void setFilteredGroupNames(String filteredGroupNames) {
        this.filteredGroupNames = Stream.of(filteredGroupNames.split("\n")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public void setSynchronisationType(String synchronisationType) {
        this.pollerConfig.setSynchronisationType(synchronisationType);
    }

    public String getCronExpression() {
        return this.pollerConfig.getCronExpression();
    }

    public void setCronExpression(String cronExpression) {
        this.setSynchronisationType("cronExpression");
        this.pollerConfig.setCronExpression(cronExpression);
    }

    public long getPollingIntervalInMin() {
        return this.pollerConfig.getPollingIntervalInMin();
    }

    public void setPollingIntervalInMin(long pollingIntervalInMin) {
        this.setSynchronisationType("pollingInterval");
        this.pollerConfig.setPollingIntervalInMin(pollingIntervalInMin);
    }

    public long getReadTimeoutInSec() {
        return this.readTimeoutInSec.getSeconds();
    }

    public void setReadTimeoutInSec(long readTimeoutInSec) {
        this.readTimeoutInSec = Duration.ofSeconds(readTimeoutInSec);
    }

    public long getConnectionTimeoutInSec() {
        return this.connectionTimeoutInSec.getSeconds();
    }

    public void setConnectionTimeoutInSec(long connectionTimeoutInSec) {
        this.connectionTimeoutInSec = Duration.ofSeconds(connectionTimeoutInSec);
    }

    public void setGroupSyncOnAuthMode(SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncOnAuthMode) {
        this.groupSyncOnAuthMode = groupSyncOnAuthMode;
    }

    public SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth getGroupSyncOnAuthMode() {
        return this.groupSyncOnAuthMode;
    }

    public boolean isPollingIntervalType() {
        return "pollingInterval".equals(this.pollerConfig.getSynchronisationType());
    }

    public boolean isCronExpressionType() {
        return "cronExpression".equals(this.pollerConfig.getSynchronisationType());
    }

    public Set<OperationType> getPermissions() {
        return this.isLocalGroupsEnabled() ? EnumSet.of(OperationType.CREATE_GROUP, OperationType.UPDATE_GROUP, OperationType.DELETE_GROUP, OperationType.UPDATE_GROUP_ATTRIBUTE) : Collections.emptySet();
    }

    @Override
    public String getPassword() {
        return this.getWebAppSecret();
    }

    @Override
    public void setPassword(String password) {
        this.setWebAppSecret(password);
    }

    @Override
    public String getPasswordAttributeKey() {
        return "AZURE_AD_WEBAPP_CLIENT_SECRET";
    }
}

