/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.internal;

import com.atlassian.crowd.embedded.admin.internal.PasswordPolicyErrorMessageBuilder;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCharacterClassConstraintException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/configure/internal-password-policy/**"})
public class PasswordPolicyConfigurationController {
    public static final String ERROR_MESSAGE_ATTRIBUTE_NAME = "errorMessage";
    public static final String PASSWORD_POLICY_CONFIGURATION_SUCCESS_ATTRIBUTE_NAME = "passwordPolicyConfigurationSuccess";
    private static final String FORM_VIEW = "configure-password-policy";
    private static final String DIRECTORY_LIST_VIEW = "redirect:/plugins/servlet/embedded-crowd/directories/list";
    private static final String CONFIGURATION_BINDING = "configuration";
    private static final String DIRECTORY_ID_BINDING = "directoryId";
    private static final String ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.errorMessage";
    private static final String DIRECTORY_NOT_FOUND_KEY = "embedded.crowd.directory.password.policy.directoryNotFound";
    private static final String DIRECTORY_NOT_INTERNAL_KEY = "embedded.crowd.directory.password.policy.directoryNotInternal";
    private static final String INVALID_PASSWORD_POLICY_KEY = "embedded.crowd.directory.password.policy.invalidPasswordPolicy";
    private static final String UNKNOWN_ERROR = "embedded.crowd.directory.password.policy.unknownError";
    private static final ImmutableMap<Class, String> EXCEPTION_CLASS_TO_ERROR_MESSAGE_KEY = ImmutableMap.of(OperationNotSupportedException.class, (Object)"embedded.crowd.directory.password.policy.directoryNotInternal", NumberFormatException.class, (Object)"embedded.crowd.directory.password.policy.directoryNotFound", DirectoryNotFoundException.class, (Object)"embedded.crowd.directory.password.policy.directoryNotFound", InvalidCharacterClassConstraintException.class, (Object)"embedded.crowd.directory.password.policy.invalidPasswordPolicy");
    private final CrowdDirectoryService crowdDirectoryService;
    private final PasswordPolicyErrorMessageBuilder passwordPolicyErrorMessageBuilder;
    private final I18nResolver i18nResolver;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public PasswordPolicyConfigurationController(CrowdDirectoryService crowdDirectoryService, PasswordPolicyErrorMessageBuilder passwordPolicyErrorMessageBuilder, I18nResolver i18nResolver, TransactionTemplate transactionTemplate) {
        this.crowdDirectoryService = crowdDirectoryService;
        this.passwordPolicyErrorMessageBuilder = passwordPolicyErrorMessageBuilder;
        this.i18nResolver = i18nResolver;
        this.transactionTemplate = transactionTemplate;
    }

    @ExceptionHandler(value={OperationNotSupportedException.class, DirectoryNotFoundException.class, NumberFormatException.class, InvalidCharacterClassConstraintException.class})
    public String handleException(Exception e, RedirectAttributes redirectAttributes) {
        String errorMessageKey = (String)EXCEPTION_CLASS_TO_ERROR_MESSAGE_KEY.getOrDefault(e.getClass(), (Object)UNKNOWN_ERROR);
        redirectAttributes.addFlashAttribute(ERROR_MESSAGE_ATTRIBUTE_NAME, (Object)this.i18nResolver.getText(ERROR_MESSAGE_KEY, new Serializable[]{this.i18nResolver.getText(errorMessageKey)}));
        return DIRECTORY_LIST_VIEW;
    }

    @RequestMapping(method={RequestMethod.GET})
    public final String initializeForm(HttpServletRequest request, ModelMap model) throws OperationNotSupportedException, DirectoryNotFoundException {
        long directoryId = Long.parseLong(request.getParameter(DIRECTORY_ID_BINDING));
        model.addAttribute(DIRECTORY_ID_BINDING, (Object)directoryId);
        model.addAttribute(CONFIGURATION_BINDING, (Object)this.crowdDirectoryService.getPasswordPolicyConfiguration(directoryId));
        return FORM_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String onSubmit(@RequestParam(name="directoryId") Long directoryId, @ModelAttribute(value="configuration") PasswordPolicyConfiguration configuration, RedirectAttributes redirectAttributes) {
        String passwordComplexityMessage = this.passwordPolicyErrorMessageBuilder.buildErrorMessageFor(configuration);
        return (String)this.transactionTemplate.execute(() -> {
            try {
                this.crowdDirectoryService.setPasswordPolicyConfiguration(directoryId.longValue(), configuration, passwordComplexityMessage);
            }
            catch (DirectoryNotFoundException | OperationNotSupportedException e) {
                return this.handleException((Exception)e, redirectAttributes);
            }
            redirectAttributes.addFlashAttribute(PASSWORD_POLICY_CONFIGURATION_SUCCESS_ATTRIBUTE_NAME, (Object)true);
            return DIRECTORY_LIST_VIEW;
        });
    }
}

