/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.internal;

import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import com.atlassian.crowd.embedded.api.PasswordPolicyConfigurationPreset;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.springframework.stereotype.Service;

@Service
public class PasswordPolicyErrorMessageBuilder {
    private static final String LENGTH_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.length.error.message";
    private static final String MATCH_COUNT_ALL_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.match.count.all.error.message";
    private static final String MATCH_COUNT_COMBINATION_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.match.count.combination.error.message";
    private static final String LENGTH_AND_MATCH_COUNT_ALL_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.length.and.match.count.all.error.message";
    private static final String LENGTH_AND_MATCH_COUNT_COMBINATION_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.length.and.match.count.combination.error.message";
    private static final String LOWERCASE_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.character.variety.lowercase.error.message";
    private static final String UPPERCASE_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.character.variety.uppercase.error.message";
    private static final String DIGITS_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.character.variety.digits.error.message";
    private static final String SPECIAL_CHARACTERS_ERROR_MESSAGE_KEY = "embedded.crowd.directory.password.policy.character.variety.special.characters.error.message";
    private final I18nResolver i18nResolver;

    public PasswordPolicyErrorMessageBuilder(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String buildErrorMessageFor(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        if (this.isDisabledOrNullOrEmpty(passwordPolicyConfiguration)) {
            return "";
        }
        PasswordPolicyConfigurationPreset preset = passwordPolicyConfiguration.getPreset();
        if (preset != null && preset != PasswordPolicyConfigurationPreset.CUSTOM) {
            passwordPolicyConfiguration = preset.buildPasswordPolicyConfiguration();
        }
        return this.buildPolicyConfigurationErrorMessage(passwordPolicyConfiguration);
    }

    private boolean isDisabledOrNullOrEmpty(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        if (passwordPolicyConfiguration == null) {
            return true;
        }
        PasswordPolicyConfigurationPreset preset = passwordPolicyConfiguration.getPreset();
        return preset != null && preset.equals((Object)PasswordPolicyConfigurationPreset.DISABLED) || (preset == null || preset.equals((Object)PasswordPolicyConfigurationPreset.CUSTOM)) && passwordPolicyConfiguration.getMinimumLength() == null && this.getCharacterTypeRuleCount(passwordPolicyConfiguration) == 0L;
    }

    private String buildPolicyConfigurationErrorMessage(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        Integer minimumLength = passwordPolicyConfiguration.getMinimumLength();
        long characterTypeRuleCount = this.getCharacterTypeRuleCount(passwordPolicyConfiguration);
        Integer minimumRulesMatched = passwordPolicyConfiguration.getMinimumRulesMatched();
        String lengthAndMatchCountErrorMessage = this.buildLengthAndMatchCountErrorMessage(characterTypeRuleCount, minimumLength, minimumRulesMatched);
        String characterTypeErrorMessage = this.buildCharacterTypeErrorMessages(passwordPolicyConfiguration);
        return new StringJoiner("\n").add(lengthAndMatchCountErrorMessage).add(characterTypeErrorMessage).toString().trim();
    }

    private String buildLengthAndMatchCountErrorMessage(long characterTypeRuleCount, Integer minimumLength, Integer minimumRulesMatched) {
        if (minimumLength == null && this.allRulesMustBeMet(minimumRulesMatched, characterTypeRuleCount)) {
            return this.i18nResolver.getText(MATCH_COUNT_ALL_ERROR_MESSAGE_KEY);
        }
        if (minimumLength == null && !this.allRulesMustBeMet(minimumRulesMatched, characterTypeRuleCount)) {
            return this.i18nResolver.getText(MATCH_COUNT_COMBINATION_ERROR_MESSAGE_KEY, new Serializable[]{minimumRulesMatched});
        }
        if (minimumLength != null && characterTypeRuleCount == 0L) {
            return this.i18nResolver.getText(LENGTH_ERROR_MESSAGE_KEY, new Serializable[]{minimumLength});
        }
        if (minimumLength != null && this.allRulesMustBeMet(minimumRulesMatched, characterTypeRuleCount)) {
            return this.i18nResolver.getText(LENGTH_AND_MATCH_COUNT_ALL_ERROR_MESSAGE_KEY, new Serializable[]{minimumLength});
        }
        return this.i18nResolver.getText(LENGTH_AND_MATCH_COUNT_COMBINATION_ERROR_MESSAGE_KEY, new Serializable[]{minimumLength, minimumRulesMatched});
    }

    private boolean allRulesMustBeMet(Integer minimumRulesMatched, long characterTypeRuleCount) {
        return minimumRulesMatched == null || (long)minimumRulesMatched.intValue() == characterTypeRuleCount;
    }

    private long getCharacterTypeRuleCount(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        return Stream.of(passwordPolicyConfiguration.getMinimumLowercase(), passwordPolicyConfiguration.getMinimumUppercase(), passwordPolicyConfiguration.getMinimumDigits(), passwordPolicyConfiguration.getMinimumSpecialCharacters()).filter(Objects::nonNull).count();
    }

    private String buildCharacterTypeErrorMessages(PasswordPolicyConfiguration passwordPolicyConfiguration) {
        StringJoiner builder = new StringJoiner("\n");
        this.appendCharacterTypeErrorMessage(builder, LOWERCASE_ERROR_MESSAGE_KEY, passwordPolicyConfiguration.getMinimumLowercase());
        this.appendCharacterTypeErrorMessage(builder, UPPERCASE_ERROR_MESSAGE_KEY, passwordPolicyConfiguration.getMinimumUppercase());
        this.appendCharacterTypeErrorMessage(builder, DIGITS_ERROR_MESSAGE_KEY, passwordPolicyConfiguration.getMinimumDigits());
        this.appendCharacterTypeErrorMessage(builder, SPECIAL_CHARACTERS_ERROR_MESSAGE_KEY, passwordPolicyConfiguration.getMinimumSpecialCharacters());
        return builder.toString();
    }

    private void appendCharacterTypeErrorMessage(StringJoiner characterTypeErrorMessagesBuilder, String errorMessageKey, Integer requiredCharacterCount) {
        Optional.ofNullable(requiredCharacterCount).map(rcc -> this.i18nResolver.getText(errorMessageKey, new Serializable[]{rcc})).ifPresent(characterTypeErrorMessagesBuilder::add);
    }
}

