/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.common.properties.SystemProperties;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.LdapTypeConfig;
import com.atlassian.crowd.embedded.admin.ConfigurationController;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfigurationValidator;
import com.atlassian.crowd.embedded.admin.plugin.PermissionOptionResolver;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/configure/activedirectory/**", "/configure/ldap/**"})
public final class LdapConfigurationController
extends ConfigurationController<LdapDirectoryConfiguration> {
    private static final String FORM_VIEW = "configure-ldap-form";
    private static final String SUCCESS_VIEW = "redirect:/plugins/servlet/embedded-crowd/directories/troubleshoot?directoryId={directoryId}&forceTest=true";
    @Autowired
    private PasswordEncoderFactory passwordEncoderFactory;
    @Autowired
    private LDAPPropertiesMapper ldapPropertiesMapper;
    @Autowired
    private PermissionOptionResolver permissionOptionResolver;

    @Override
    protected String getFormView() {
        return FORM_VIEW;
    }

    @Override
    protected String getSuccessView() {
        return SUCCESS_VIEW;
    }

    @Override
    protected Directory createDirectory(LdapDirectoryConfiguration command) {
        return this.directoryMapper.buildLdapDirectory(command);
    }

    @Override
    protected Directory createUpdatedDirectory(Directory oldDirectory, Directory newDirectory) {
        Directory updatedDirectory = super.createUpdatedDirectory(oldDirectory, newDirectory);
        if (this.isLdapFastMembershipSyncOverriddenGlobally()) {
            return ImmutableDirectory.builder((Directory)updatedDirectory).setAttribute("ldap.fast.membership.sync", (String)oldDirectory.getAttributes().get("ldap.fast.membership.sync")).build();
        }
        return updatedDirectory;
    }

    @Override
    protected Directory createDirectoryToStore(Directory directory) {
        Directory updatedDirectory = super.createDirectoryToStore(directory);
        if (this.isLdapFastMembershipSyncOverriddenGlobally()) {
            return ImmutableDirectory.builder((Directory)updatedDirectory).setAttribute("ldap.fast.membership.sync", Boolean.toString((Boolean)SystemProperties.USE_LEGACY_AD_MEMBERSHIP_SYNC.getValue() == false)).build();
        }
        return updatedDirectory;
    }

    @Override
    protected LdapDirectoryConfiguration createConfigurationFromRequest(HttpServletRequest request) throws Exception {
        if (this.directoryContextHelper.hasDirectoryId(request)) {
            Directory directory = this.directoryContextHelper.getDirectory(request);
            LdapDirectoryConfiguration configuration = this.directoryMapper.toLdapConfiguration(directory);
            this.setFastLdapMembershipSyncToGloballyOverwrittenValue(configuration);
            return configuration;
        }
        LdapDirectoryConfiguration configuration = new LdapDirectoryConfiguration();
        this.setFastLdapMembershipSyncToGloballyOverwrittenValue(configuration);
        if (request.getPathInfo().endsWith("/activedirectory/")) {
            configuration.setType(MicrosoftActiveDirectory.class.getName());
            configuration.setName(this.getI18nResolver().getText("embedded.crowd.directory.edit.ldap.field.default.ad"));
        } else {
            configuration.setName(this.getI18nResolver().getText("embedded.crowd.directory.edit.ldap.field.default.ldap"));
        }
        configuration.setLdapAutoAddGroups(this.getDefaultLdapAutoAddGroups());
        this.directoryMapper.setDefaultSpringLdapProperties(configuration);
        return configuration;
    }

    private void setFastLdapMembershipSyncToGloballyOverwrittenValue(LdapDirectoryConfiguration configuration) {
        if (this.isLdapFastMembershipSyncOverriddenGlobally()) {
            configuration.setLdapFastMembershipSync((Boolean)SystemProperties.USE_LEGACY_AD_MEMBERSHIP_SYNC.getValue() == false);
        }
    }

    @PostMapping
    public ModelAndView onSubmit(HttpServletRequest request, @Valid @ModelAttribute(value="configuration") LdapDirectoryConfiguration configuration, BindingResult errors) throws Exception {
        return this.handleSubmit(request, configuration, errors);
    }

    @InitBinder
    protected void initRequiredFields(WebDataBinder binder) {
        binder.setRequiredFields(new String[]{"name", "type", "hostname", "port", "ldapPermissionOption", "ldapUserObjectclass", "ldapUserFilter", "ldapUserUsername", "ldapUserFirstname", "ldapUserLastname", "ldapUserDisplayname", "ldapUserEmail", "ldapUserGroup", "ldapUserPassword", "ldapGroupObjectclass", "ldapGroupFilter", "ldapGroupName", "ldapGroupDescription", "ldapGroupUsernames", "ldapCacheSynchroniseIntervalInMin"});
    }

    @InitBinder(value={"configuration"})
    protected void initConfigurationValidator(WebDataBinder binder) {
        binder.setValidator((Validator)new LdapDirectoryConfigurationValidator());
    }

    @ModelAttribute(value="ldapDirectoryTypes")
    public Map<String, String> getLdapDirectoryTypes() {
        return this.ldapPropertiesMapper.getImplementations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    @ModelAttribute(value="ldapPermissionOptions")
    public List<String> getLdapPermissionOptions() {
        return this.permissionOptionResolver.getEnabledPermissionOptions().stream().map(Enum::name).collect(Collectors.toList());
    }

    @ModelAttribute(value="ldapTypeConfigurations")
    public List<LdapTypeConfig> getLdapTypeConfigurations() {
        return this.ldapPropertiesMapper.getLdapTypeConfigurations();
    }

    @ModelAttribute(value="ldapPasswordEncryptionTypes")
    public Map<String, String> getPasswordEncryptionTypes() {
        return this.passwordEncoderFactory.getSupportedLdapEncoders().stream().collect(Collectors.toMap(Function.identity(), String::toUpperCase));
    }

    @ModelAttribute(value="ldapFastMembershipSyncOverriddenGlobally")
    public boolean isLdapFastMembershipSyncOverriddenGlobally() {
        return SystemProperties.USE_LEGACY_AD_MEMBERSHIP_SYNC.isDefined();
    }
}

