/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import java.util.Collections;

public class InternalDirectoryOptionsModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private boolean editable;
    private boolean passwordPolicyConfigurationEnabled;

    public InternalDirectoryOptionsModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("editable") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("Must specify attribute editable with value 'true' or 'false'."));
        }
        if (element.attributeValue("password-policy-configuration-enabled") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("Must specify attribute password-policy-configuration-enabled with value 'true' or 'false'."));
        }
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.editable = Boolean.parseBoolean(element.attributeValue("editable"));
        this.passwordPolicyConfigurationEnabled = Boolean.parseBoolean(element.attributeValue("password-policy-configuration-enabled"));
    }

    public Void getModule() {
        return null;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isPasswordPolicyConfigurationEnabled() {
        return this.passwordPolicyConfigurationEnabled;
    }
}

