/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.rest;

import com.atlassian.crowd.embedded.admin.rest.entities.ApplicationEntity;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@Path(value="/application")
@Produces(value={"application/xml", "application/json"})
@SystemAdminOnly
public class ApplicationResource {
    @Context
    private UriInfo uriInfo;
    private final CrowdDirectoryService crowdDirectoryService;

    @Inject
    public ApplicationResource(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @GET
    public ApplicationEntity get() {
        boolean membershipAggregationEnabled = this.crowdDirectoryService.isMembershipAggregationEnabled();
        ApplicationEntity entity = new ApplicationEntity();
        entity.setMembershipAggregationEnabled(membershipAggregationEnabled);
        return entity;
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    public Response update(ApplicationEntity entity) {
        Boolean membershipAggregationEnabled = entity.isMembershipAggregationEnabled();
        if (membershipAggregationEnabled != null) {
            this.crowdDirectoryService.setMembershipAggregationEnabled(membershipAggregationEnabled.booleanValue());
        }
        return Response.noContent().build();
    }
}

