/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.rest;

import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.scheduler.caesium.impl.RunTimeCalculator;
import com.atlassian.scheduler.config.Schedule;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

@Path(value="/scheduler")
@SystemAdminOnly
public class SynchronizationScheduleResource {
    private final RunTimeCalculator runTimeCalculator = new RunTimeCalculator(TimeZone::getDefault);

    @GET
    @Path(value="/future-schedules")
    @Produces(value={"application/json"})
    public List<String> futureSchedules(@QueryParam(value="scheduleType") Schedule.Type scheduleType, @QueryParam(value="expression") String expression, @QueryParam(value="numberOfFutureSchedules") int numberOfFutureSchedules, @Context HttpHeaders headers) throws IOException {
        ArrayList<String> futureSchedules = new ArrayList<String>();
        try {
            Locale requestLocale = headers.getAcceptableLanguages().stream().findFirst().orElse(Locale.getDefault());
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, requestLocale);
            Schedule schedule = null;
            switch (scheduleType) {
                case CRON_EXPRESSION: {
                    schedule = Schedule.forCronExpression((String)expression);
                    break;
                }
                case INTERVAL: {
                    schedule = Schedule.forInterval((long)(Long.parseLong(expression) * 60L * 1000L), (Date)new Date());
                }
            }
            if (schedule != null) {
                Date nextRunTime = null;
                for (int i = 0; i < numberOfFutureSchedules; ++i) {
                    nextRunTime = this.runTimeCalculator.nextRunTime(schedule, nextRunTime);
                    futureSchedules.add(dateFormat.format(nextRunTime));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return futureSchedules;
    }
}

