/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.springmvc.interceptor;

import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public final class WebSudoAuthorisationInterceptor
implements HandlerInterceptor {
    private final WebSudoManager webSudoManager;
    private final String postRedirectPath;

    public WebSudoAuthorisationInterceptor(WebSudoManager webSudoManager, String postRedirectPath) {
        this.webSudoManager = webSudoManager;
        this.postRedirectPath = postRedirectPath;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            return true;
        }
        catch (WebSudoSessionException wes) {
            if (request.getMethod().equals(RequestMethod.POST.toString())) {
                response.sendRedirect(request.getContextPath() + request.getServletPath() + this.postRedirectPath);
                return false;
            }
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return false;
        }
    }
}

