/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.viewsource.api.v1;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Objects;

@Path(value="/")
@Produces(value={"application/json"})
public class ViewSourceResource {
    private final ContentEntityManager contentEntityManager;
    private final PermissionManager permissionManager;
    private final Renderer renderer;

    @Inject
    public ViewSourceResource(ContentEntityManager contentEntityManager, PermissionManager permissionManager, Renderer renderer) {
        this.contentEntityManager = Objects.requireNonNull(contentEntityManager);
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.renderer = Objects.requireNonNull(renderer);
    }

    @GET
    @Path(value="getPageSrc")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getPageSource(@QueryParam(value="pageId") long pageId) {
        ContentEntityObject content = this.contentEntityManager.getById(pageId);
        if (content == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)content)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("content", this.renderer.render(content));
        return Response.ok().entity(result).build();
    }
}

