/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.hibernate;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.hibernate.AbstractNutclusterCacheRegionFactory;
import com.atlassian.nutcluster.hibernate.RegionCache;
import com.atlassian.nutcluster.hibernate.distributed.IMapRegionCache;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class NutclusterCacheRegionFactory
extends AbstractNutclusterCacheRegionFactory {
    public NutclusterCacheRegionFactory() {
    }

    public NutclusterCacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        super(cacheKeysFactory);
    }

    public NutclusterCacheRegionFactory(NutclusterInstance instance) {
        super(instance);
    }

    @Override
    protected RegionCache createRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory, DomainDataRegionConfig regionConfig) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        return new IMapRegionCache((RegionFactory)this, qualifiedRegionName, this.instance);
    }

    @Override
    protected RegionCache createTimestampsRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        return new IMapRegionCache((RegionFactory)this, qualifiedRegionName, this.instance);
    }
}

