/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.hibernate;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.hibernate.AbstractNutclusterCacheRegionFactory;
import com.atlassian.nutcluster.hibernate.NutclusterTimestamper;
import com.atlassian.nutcluster.hibernate.RegionCache;
import com.atlassian.nutcluster.hibernate.local.LocalRegionCache;
import com.atlassian.nutcluster.hibernate.local.TimestampsRegionCache;
import com.atlassian.nutcluster.util.Clock;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class NutclusterLocalCacheRegionFactory
extends AbstractNutclusterCacheRegionFactory {
    public NutclusterLocalCacheRegionFactory() {
    }

    public NutclusterLocalCacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        super(cacheKeysFactory);
    }

    public NutclusterLocalCacheRegionFactory(NutclusterInstance instance) {
        super(instance);
    }

    @Override
    protected RegionCache createRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory, DomainDataRegionConfig regionConfig) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        LocalRegionCache regionCache = new LocalRegionCache((RegionFactory)this, qualifiedRegionName, this.instance, regionConfig);
        this.cleanupService.registerCache(regionCache);
        return regionCache;
    }

    @Override
    protected RegionCache createTimestampsRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        return new TimestampsRegionCache((RegionFactory)this, qualifiedRegionName, this.instance);
    }

    public long nextTimestamp() {
        long result = this.instance == null ? Clock.currentTimeMillis() : NutclusterTimestamper.nextTimestamp(this.instance);
        return result;
    }
}

