/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.hibernate;

import com.atlassian.nutcluster.core.OperationTimeoutException;
import com.atlassian.nutcluster.hibernate.NutclusterStorageAccess;
import com.atlassian.nutcluster.hibernate.RegionCache;
import com.atlassian.nutcluster.logging.Logger;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class NutclusterStorageAccessImpl
implements NutclusterStorageAccess {
    private final RegionCache delegate;

    NutclusterStorageAccessImpl(RegionCache delegate) {
        this.delegate = delegate;
    }

    @Override
    public void afterUpdate(Object key, Object newValue, Object newVersion) {
        this.delegate.afterUpdate(key, newValue, newVersion);
    }

    public boolean contains(Object key) {
        return this.delegate.contains(key);
    }

    public void evictData() throws CacheException {
        try {
            this.delegate.evictData();
        }
        catch (OperationTimeoutException e) {
            Logger.getLogger(NutclusterStorageAccessImpl.class).finest((Throwable)e);
        }
    }

    public void evictData(Object key) throws CacheException {
        try {
            this.delegate.evictData(key);
        }
        catch (OperationTimeoutException e) {
            Logger.getLogger(NutclusterStorageAccessImpl.class).finest((Throwable)e);
        }
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) throws CacheException {
        try {
            return this.delegate.get(key, this.nextTimestamp());
        }
        catch (OperationTimeoutException e) {
            return null;
        }
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) throws CacheException {
        try {
            this.delegate.put(key, value, this.nextTimestamp(), null);
        }
        catch (OperationTimeoutException e) {
            Logger.getLogger(NutclusterStorageAccessImpl.class).finest((Throwable)e);
        }
    }

    public void release() {
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) {
        this.delegate.unlockItem(key, lock);
    }

    RegionCache getDelegate() {
        return this.delegate;
    }

    private long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }
}

