/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.hibernate.distributed;

import com.atlassian.nutcluster.core.EntryView;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.hibernate.RegionCache;
import com.atlassian.nutcluster.hibernate.serialization.Expirable;
import com.atlassian.nutcluster.hibernate.serialization.Value;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.SoftLock;

public class IMapRegionCache
implements RegionCache {
    private final IMap<Object, Expirable> map;
    private final String name;
    private final RegionFactory regionFactory;

    public IMapRegionCache(RegionFactory regionFactory, String name, NutclusterInstance nutclusterInstance) {
        this.name = name;
        this.regionFactory = regionFactory;
        this.map = nutclusterInstance.getMap(this.name);
    }

    @Override
    public void afterUpdate(Object key, Object newValue, Object newVersion) {
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void evictData() {
        this.map.evictAll();
    }

    @Override
    public void evictData(Object key) {
        this.map.remove(key);
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable entry = (Expirable)this.map.get(key);
        return entry == null ? null : entry.getValue(txTimestamp);
    }

    public long getElementCountInMemory() {
        return this.map.size();
    }

    public String getName() {
        return this.name;
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.map.keySet()) {
            EntryView entry = this.map.getEntryView(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        Value newValue = new Value(version, txTimestamp, value);
        this.map.put(key, (Object)newValue);
        return true;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) {
    }
}

