/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.hibernate.instance;

import com.atlassian.nutcluster.client.NutclusterClient;
import com.atlassian.nutcluster.client.config.ClientConfig;
import com.atlassian.nutcluster.client.config.XmlClientConfigBuilder;
import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.hibernate.CacheEnvironment;
import com.atlassian.nutcluster.hibernate.instance.INutclusterInstanceLoader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.internal.util.config.ConfigurationHelper;

class NutclusterClientLoader
implements INutclusterInstanceLoader {
    private static final int CONNECTION_ATTEMPT_LIMIT = 10;
    private NutclusterInstance client;
    private ClientConfig clientConfig;
    private String instanceName;

    NutclusterClientLoader() {
    }

    @Override
    public void configure(Properties props) {
        this.instanceName = ConfigurationHelper.getString((String)"hibernate.cache.nutcluster.native_client_instance_name", (Map)props, null);
        if (this.instanceName != null) {
            return;
        }
        String address = ConfigurationHelper.getString((String)"hibernate.cache.nutcluster.native_client_address", (Map)props, null);
        String group = ConfigurationHelper.getString((String)"hibernate.cache.nutcluster.native_client_group", (Map)props, null);
        String pass = ConfigurationHelper.getString((String)"hibernate.cache.nutcluster.native_client_password", (Map)props, null);
        String configResourcePath = CacheEnvironment.getConfigFilePath(props);
        if (configResourcePath != null) {
            try {
                this.clientConfig = new XmlClientConfigBuilder(configResourcePath).build();
            }
            catch (IOException e) {
                throw new NutclusterException("Could not load client configuration: " + configResourcePath, (Throwable)e);
            }
        } else {
            this.clientConfig = new ClientConfig();
        }
        if (group != null) {
            this.clientConfig.getGroupConfig().setName(group);
        }
        if (pass != null) {
            this.clientConfig.getGroupConfig().setPassword(pass);
        }
        if (address != null) {
            this.clientConfig.getNetworkConfig().addAddress(new String[]{address});
        }
        this.clientConfig.getNetworkConfig().setSmartRouting(true);
        this.clientConfig.getNetworkConfig().setRedoOperation(true);
        this.clientConfig.getNetworkConfig().setConnectionAttemptLimit(10);
    }

    @Override
    public NutclusterInstance loadInstance() throws CacheException {
        if (this.instanceName != null) {
            this.client = NutclusterClient.getNutclusterClientByName((String)this.instanceName);
            if (this.client == null) {
                throw new CacheException("No client with name [" + this.instanceName + "] could be found.");
            }
        } else {
            this.client = NutclusterClient.newNutclusterClient((ClientConfig)this.clientConfig);
        }
        return this.client;
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.getLifecycleService().shutdown();
            this.client = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

