/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.AbstractCacheManager;
import com.atlassian.cache.impl.WeakSupplier;
import com.atlassian.cache.impl.metrics.CacheManagerMetricEmitter;
import com.atlassian.cache.impl.metrics.InstrumentedCache;
import com.atlassian.cache.impl.metrics.InstrumentedCachedReference;
import com.atlassian.confluence.cache.CacheConfigManager;
import com.atlassian.confluence.cache.ConfluenceCache;
import com.atlassian.confluence.cache.ConfluenceCachedReference;
import io.atlassian.util.concurrent.ManagedLock;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CacheManagerTemplate
extends AbstractCacheManager
implements CacheConfigManager {
    private static final Logger log = LoggerFactory.getLogger(CacheManagerTemplate.class);

    public CacheManagerTemplate(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider, CacheManagerMetricEmitter cacheManagerMetricEmitter) {
        super(cacheSettingsDefaultsProvider, cacheManagerMetricEmitter);
    }

    protected final ManagedCache createSimpleCache(String name, CacheSettings settings) {
        return this.getOrCreateCache(name, () -> this.createCacheInternal(name, settings, null));
    }

    protected final <K, V> ManagedCache createComputingCache(String name, CacheSettings settings, CacheLoader<K, V> loader) {
        return this.getOrCreateCache(name, () -> this.createCacheInternal(name, settings, loader));
    }

    public final <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        return (CachedReference)this.getOrCreateCachedReference(name, () -> this.createCachedReferenceInternal(name, supplier, settings));
    }

    protected abstract <K, V> ConfluenceCache<K, V> createCacheInternal(String var1, CacheSettings var2, @Nullable CacheLoader<K, V> var3);

    protected abstract <V> ConfluenceCachedReference<V> createCachedReferenceInternal(String var1, Supplier<V> var2, CacheSettings var3);

    @Override
    public final void changeMaxCacheSize(String cacheName, int newMaxCacheSize) {
        boolean success = this.getManagedCache(cacheName).updateMaxEntries(newMaxCacheSize);
        if (!success) {
            log.warn("Failed to update max size for cache [{}]", (Object)cacheName);
        }
    }

    public final Collection<ManagedCache> getManagedCaches() {
        return this.caches.keySet().stream().map(this::getManagedCache).toList();
    }

    protected final <K, V> ManagedCache getOrCreateCache(String name, Supplier<ConfluenceCache<K, V>> factory) {
        return this.getOr(name, (Supplier<ManagedCache>)((Supplier)() -> (ManagedCache)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock((java.util.function.Supplier)((Supplier)() -> this.getOr(name, (Supplier<ManagedCache>)((Supplier)() -> {
            InstrumentedCache cache = InstrumentedCache.wrap((Cache)((Cache)factory.get()));
            this.caches.put(name, new WeakSupplier((Object)cache));
            return cache;
        }))))));
    }

    protected final <V> ManagedCache getOrCreateCachedReference(String name, Supplier<ConfluenceCachedReference<V>> factory) {
        return this.getOr(name, (Supplier<ManagedCache>)((Supplier)() -> (ManagedCache)((ManagedLock)this.cacheCreationLocks.apply(name)).withLock((java.util.function.Supplier)((Supplier)() -> this.getOr(name, (Supplier<ManagedCache>)((Supplier)() -> {
            InstrumentedCachedReference cache = InstrumentedCachedReference.wrap((CachedReference)((CachedReference)factory.get()));
            this.caches.put(name, new WeakSupplier((Object)cache));
            return cache;
        }))))));
    }

    private ManagedCache getOr(String name, Supplier<ManagedCache> factory) {
        ManagedCache existingCache;
        java.util.function.Supplier existingCacheRef = (java.util.function.Supplier)this.caches.get(name);
        ManagedCache managedCache = existingCache = existingCacheRef == null ? null : (ManagedCache)existingCacheRef.get();
        if (existingCacheRef != null && existingCache == null) {
            log.debug("Existing ref to cache [{}] has been discarded by GC", (Object)name);
        }
        return existingCache != null ? existingCache : (ManagedCache)factory.get();
    }

    public final ManagedCache getManagedCache(String cacheName) {
        return this.getOrCreateCache(cacheName, () -> this.createCacheInternal(cacheName, this.mergeSettings(cacheName, new CacheSettingsBuilder().build()), null));
    }
}

