/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.lang.Nullable;

public class PreparedStatementCreatorFactory {
    private final String sql;
    @Nullable
    private List<SqlParameter> declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private boolean returnGeneratedKeys = false;
    @Nullable
    private String[] generatedKeysColumnNames;

    public PreparedStatementCreatorFactory(String sql) {
        this.sql = sql;
    }

    public PreparedStatementCreatorFactory(String sql, int ... types) {
        this.sql = sql;
        this.declaredParameters = SqlParameter.sqlTypesToAnonymousParameterList(types);
    }

    public PreparedStatementCreatorFactory(String sql, List<SqlParameter> declaredParameters) {
        this.sql = sql;
        this.declaredParameters = declaredParameters;
    }

    public final String getSql() {
        return this.sql;
    }

    public void addParameter(SqlParameter param) {
        if (this.declaredParameters == null) {
            this.declaredParameters = new ArrayList<SqlParameter>();
        }
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public void setReturnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public void setGeneratedKeysColumnNames(String ... names) {
        this.generatedKeysColumnNames = names;
    }

    public PreparedStatementSetter newPreparedStatementSetter(@Nullable List<?> params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.emptyList());
    }

    public PreparedStatementSetter newPreparedStatementSetter(@Nullable Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.emptyList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(@Nullable List<?> params) {
        return new PreparedStatementCreatorImpl(params != null ? params : Collections.emptyList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(@Nullable Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : Collections.emptyList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(String sqlToUse, @Nullable Object[] params) {
        return new PreparedStatementCreatorImpl(sqlToUse, params != null ? Arrays.asList(params) : Collections.emptyList());
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider,
    ParameterDisposer {
        private final String actualSql;
        private final List<?> parameters;

        public PreparedStatementCreatorImpl(List<?> parameters) {
            this(preparedStatementCreatorFactory.sql, parameters);
        }

        public PreparedStatementCreatorImpl(String actualSql, List<?> parameters) {
            this.actualSql = actualSql;
            this.parameters = parameters;
            if (PreparedStatementCreatorFactory.this.declaredParameters != null && parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                HashSet<Object> names = new HashSet<Object>();
                for (int i2 = 0; i2 < parameters.size(); ++i2) {
                    Object param = parameters.get(i2);
                    if (param instanceof SqlParameterValue) {
                        SqlParameterValue sqlParameterValue = (SqlParameterValue)param;
                        names.add(sqlParameterValue.getName());
                        continue;
                    }
                    names.add("Parameter #" + i2);
                }
                if (names.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                    throw new InvalidDataAccessApiUsageException("SQL [" + PreparedStatementCreatorFactory.this.sql + "]: given " + names.size() + " parameters but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
                }
            }
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = PreparedStatementCreatorFactory.this.generatedKeysColumnNames != null || PreparedStatementCreatorFactory.this.returnGeneratedKeys ? (PreparedStatementCreatorFactory.this.generatedKeysColumnNames != null ? con.prepareStatement(this.actualSql, PreparedStatementCreatorFactory.this.generatedKeysColumnNames) : con.prepareStatement(this.actualSql, 1)) : (PreparedStatementCreatorFactory.this.resultSetType == 1003 && !PreparedStatementCreatorFactory.this.updatableResults ? con.prepareStatement(this.actualSql) : con.prepareStatement(this.actualSql, PreparedStatementCreatorFactory.this.resultSetType, PreparedStatementCreatorFactory.this.updatableResults ? 1008 : 1007));
            this.setValues(ps);
            return ps;
        }

        @Override
        public void setValues(PreparedStatement ps) throws SQLException {
            int sqlColIndx = 1;
            for (int i2 = 0; i2 < this.parameters.size(); ++i2) {
                Object in = this.parameters.get(i2);
                SqlParameter declaredParameter = null;
                if (in instanceof SqlParameterValue) {
                    SqlParameterValue sqlParameterValue = (SqlParameterValue)in;
                    in = sqlParameterValue.getValue();
                    declaredParameter = sqlParameterValue;
                } else if (PreparedStatementCreatorFactory.this.declaredParameters != null) {
                    if (PreparedStatementCreatorFactory.this.declaredParameters.size() <= i2) {
                        throw new InvalidDataAccessApiUsageException("SQL [" + PreparedStatementCreatorFactory.this.sql + "]: unable to access parameter number " + (i2 + 1) + " given only " + PreparedStatementCreatorFactory.this.declaredParameters.size() + " parameters");
                    }
                    declaredParameter = PreparedStatementCreatorFactory.this.declaredParameters.get(i2);
                }
                if (declaredParameter == null) {
                    StatementCreatorUtils.setParameterValue(ps, sqlColIndx++, Integer.MIN_VALUE, in);
                    continue;
                }
                if (in instanceof Iterable) {
                    Iterable entries = (Iterable)in;
                    if (declaredParameter.getSqlType() != 2003) {
                        for (Object entry : entries) {
                            if (entry instanceof Object[]) {
                                Object[] valueArray;
                                for (Object argValue : valueArray = (Object[])entry) {
                                    StatementCreatorUtils.setParameterValue(ps, sqlColIndx++, declaredParameter, argValue);
                                }
                                continue;
                            }
                            StatementCreatorUtils.setParameterValue(ps, sqlColIndx++, declaredParameter, entry);
                        }
                        continue;
                    }
                }
                StatementCreatorUtils.setParameterValue(ps, sqlColIndx++, declaredParameter, in);
            }
        }

        @Override
        public String getSql() {
            return PreparedStatementCreatorFactory.this.sql;
        }

        @Override
        public void cleanupParameters() {
            StatementCreatorUtils.cleanupParameters(this.parameters);
        }

        public String toString() {
            return "PreparedStatementCreator: sql=[" + PreparedStatementCreatorFactory.this.sql + "]; parameters=" + String.valueOf(this.parameters);
        }
    }
}

