/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SimplePropertyRowMapper<T>
implements RowMapper<T> {
    private static final Object NO_DESCRIPTOR = new Object();
    private final Class<T> mappedClass;
    private final ConversionService conversionService;
    private final Constructor<T> mappedConstructor;
    private final String[] constructorParameterNames;
    private final TypeDescriptor[] constructorParameterTypes;
    private final Map<String, Object> propertyDescriptors = new ConcurrentHashMap<String, Object>();

    public SimplePropertyRowMapper(Class<T> mappedClass) {
        this(mappedClass, DefaultConversionService.getSharedInstance());
    }

    public SimplePropertyRowMapper(Class<T> mappedClass, ConversionService conversionService) {
        Assert.notNull(mappedClass, "Mapped Class must not be null");
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.mappedClass = mappedClass;
        this.conversionService = conversionService;
        this.mappedConstructor = BeanUtils.getResolvableConstructor(mappedClass);
        int paramCount = this.mappedConstructor.getParameterCount();
        this.constructorParameterNames = paramCount > 0 ? BeanUtils.getParameterNames(this.mappedConstructor) : new String[]{};
        this.constructorParameterTypes = new TypeDescriptor[paramCount];
        for (int i2 = 0; i2 < paramCount; ++i2) {
            this.constructorParameterTypes[i2] = new TypeDescriptor(new MethodParameter(this.mappedConstructor, i2));
        }
    }

    @Override
    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        Object[] args = new Object[this.constructorParameterNames.length];
        HashSet<Integer> usedIndex = new HashSet<Integer>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            int index;
            String name = this.constructorParameterNames[i2];
            try {
                index = rs.findColumn(name);
            }
            catch (SQLException ex) {
                index = rs.findColumn(JdbcUtils.convertPropertyNameToUnderscoreName(name));
            }
            TypeDescriptor td = this.constructorParameterTypes[i2];
            Object value = JdbcUtils.getResultSetValue(rs, index, td.getType());
            usedIndex.add(index);
            args[i2] = this.conversionService.convert(value, td);
        }
        T mappedObject = BeanUtils.instantiateClass(this.mappedConstructor, args);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            if (usedIndex.contains(index)) continue;
            Object desc = this.getDescriptor(JdbcUtils.lookupColumnName(rsmd, index));
            if (desc instanceof MethodParameter) {
                MethodParameter mp = (MethodParameter)desc;
                Method method = mp.getMethod();
                if (method == null) continue;
                Object value = JdbcUtils.getResultSetValue(rs, index, mp.getParameterType());
                value = this.conversionService.convert(value, new TypeDescriptor(mp));
                ReflectionUtils.makeAccessible(method);
                ReflectionUtils.invokeMethod(method, mappedObject, value);
                continue;
            }
            if (!(desc instanceof Field)) continue;
            Field field = (Field)desc;
            Object value = JdbcUtils.getResultSetValue(rs, index, field.getType());
            value = this.conversionService.convert(value, new TypeDescriptor(field));
            ReflectionUtils.makeAccessible(field);
            ReflectionUtils.setField(field, mappedObject, value);
        }
        return mappedObject;
    }

    private Object getDescriptor(String column) {
        return this.propertyDescriptors.computeIfAbsent(column, name -> {
            PropertyDescriptor[] pds;
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(this.mappedClass, name);
            if (pd != null && pd.getWriteMethod() != null) {
                return BeanUtils.getWriteMethodParameter(pd);
            }
            Field field = ReflectionUtils.findField(this.mappedClass, name);
            if (field != null) {
                return field;
            }
            String adaptedName = JdbcUtils.convertUnderscoreNameToPropertyName(name);
            if (!adaptedName.equals(name)) {
                pd = BeanUtils.getPropertyDescriptor(this.mappedClass, adaptedName);
                if (pd != null && pd.getWriteMethod() != null) {
                    return BeanUtils.getWriteMethodParameter(pd);
                }
                field = ReflectionUtils.findField(this.mappedClass, adaptedName);
                if (field != null) {
                    return field;
                }
            }
            for (PropertyDescriptor candidate : pds = BeanUtils.getPropertyDescriptors(this.mappedClass)) {
                if (!name.equalsIgnoreCase(candidate.getName())) continue;
                return BeanUtils.getWriteMethodParameter(candidate);
            }
            field = ReflectionUtils.findFieldIgnoreCase(this.mappedClass, name);
            if (field != null) {
                return field;
            }
            return NO_DESCRIPTOR;
        });
    }
}

