/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.metadata.CallMetaDataContext;
import org.springframework.jdbc.core.metadata.CallMetaDataProvider;
import org.springframework.jdbc.core.metadata.Db2CallMetaDataProvider;
import org.springframework.jdbc.core.metadata.DerbyCallMetaDataProvider;
import org.springframework.jdbc.core.metadata.GenericCallMetaDataProvider;
import org.springframework.jdbc.core.metadata.HanaCallMetaDataProvider;
import org.springframework.jdbc.core.metadata.OracleCallMetaDataProvider;
import org.springframework.jdbc.core.metadata.PostgresCallMetaDataProvider;
import org.springframework.jdbc.core.metadata.SqlServerCallMetaDataProvider;
import org.springframework.jdbc.core.metadata.SybaseCallMetaDataProvider;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public final class CallMetaDataProviderFactory {
    private static final String DB2 = "DB2";
    private static final String DERBY = "Apache Derby";
    private static final String HANA = "HDB";
    private static final String INFORMIX = "Informix Dynamic Server";
    private static final String MARIA = "MariaDB";
    private static final String MS_SQL_SERVER = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static final String ORACLE = "Oracle";
    private static final String POSTGRES = "PostgreSQL";
    private static final String SYBASE = "Sybase";
    public static final List<String> supportedDatabaseProductsForProcedures = List.of("Apache Derby", "DB2", "Informix Dynamic Server", "MariaDB", "Microsoft SQL Server", "MySQL", "Oracle", "PostgreSQL", "Sybase");
    public static final List<String> supportedDatabaseProductsForFunctions = List.of("MariaDB", "Microsoft SQL Server", "MySQL", "Oracle", "PostgreSQL");
    private static final Log logger = LogFactory.getLog(CallMetaDataProviderFactory.class);

    private CallMetaDataProviderFactory() {
    }

    public static CallMetaDataProvider createMetaDataProvider(DataSource dataSource, CallMetaDataContext context) {
        try {
            return JdbcUtils.extractDatabaseMetaData(dataSource, databaseMetaData -> {
                GenericCallMetaDataProvider provider;
                String databaseProductName = JdbcUtils.commonDatabaseName(databaseMetaData.getDatabaseProductName());
                if (databaseProductName == null) {
                    databaseProductName = "";
                }
                boolean accessProcedureColumnMetaData = context.isAccessCallParameterMetaData();
                if (context.isFunction()) {
                    if (!supportedDatabaseProductsForFunctions.contains(databaseProductName)) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)(databaseProductName + " is not one of the databases fully supported for function calls -- supported are: " + String.valueOf(supportedDatabaseProductsForFunctions)));
                        }
                        if (accessProcedureColumnMetaData) {
                            logger.info((Object)"Metadata processing disabled - you must specify all parameters explicitly");
                            accessProcedureColumnMetaData = false;
                        }
                    }
                } else if (!supportedDatabaseProductsForProcedures.contains(databaseProductName)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(databaseProductName + " is not one of the databases fully supported for procedure calls -- supported are: " + String.valueOf(supportedDatabaseProductsForProcedures)));
                    }
                    if (accessProcedureColumnMetaData) {
                        logger.info((Object)"Metadata processing disabled - you must specify all parameters explicitly");
                        accessProcedureColumnMetaData = false;
                    }
                }
                switch (databaseProductName) {
                    case "Oracle": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new OracleCallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    case "PostgreSQL": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new PostgresCallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    case "Apache Derby": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new DerbyCallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    case "DB2": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new Db2CallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    case "HDB": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new HanaCallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    case "Microsoft SQL Server": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new SqlServerCallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    case "Sybase": {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = new SybaseCallMetaDataProvider(databaseMetaData);
                        break;
                    }
                    default: {
                        GenericCallMetaDataProvider genericCallMetaDataProvider = provider = new GenericCallMetaDataProvider(databaseMetaData);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using " + provider.getClass().getName()));
                }
                provider.initializeWithMetaData(databaseMetaData);
                if (accessProcedureColumnMetaData) {
                    provider.initializeWithProcedureColumnMetaData(databaseMetaData, context.getCatalogName(), context.getSchemaName(), context.getProcedureName());
                }
                return provider;
            });
        }
        catch (MetaDataAccessException ex) {
            throw new DataAccessResourceFailureException("Error retrieving database meta-data", ex);
        }
    }
}

