/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.DefaultJdbcClient;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.Nullable;

public interface JdbcClient {
    public StatementSpec sql(String var1);

    public static JdbcClient create(DataSource dataSource) {
        return new DefaultJdbcClient(dataSource);
    }

    public static JdbcClient create(JdbcOperations jdbcTemplate) {
        return new DefaultJdbcClient(jdbcTemplate);
    }

    public static JdbcClient create(NamedParameterJdbcOperations jdbcTemplate) {
        return new DefaultJdbcClient(jdbcTemplate);
    }

    public static interface MappedQuerySpec<T> {
        public Stream<T> stream();

        public List<T> list();

        default public Set<T> set() {
            return new LinkedHashSet<T>(this.list());
        }

        default public T single() {
            return DataAccessUtils.requiredSingleResult(this.list());
        }

        default public Optional<T> optional() {
            return DataAccessUtils.optionalResult(this.list());
        }
    }

    public static interface ResultQuerySpec {
        public SqlRowSet rowSet();

        public List<Map<String, Object>> listOfRows();

        public Map<String, Object> singleRow();

        public List<Object> singleColumn();

        default public Object singleValue() {
            return DataAccessUtils.requiredSingleResult(this.singleColumn());
        }

        default public Optional<Object> optionalValue() {
            return DataAccessUtils.optionalResult(this.singleColumn());
        }
    }

    public static interface StatementSpec {
        public StatementSpec param(@Nullable Object var1);

        public StatementSpec param(int var1, @Nullable Object var2);

        public StatementSpec param(int var1, @Nullable Object var2, int var3);

        public StatementSpec param(String var1, @Nullable Object var2);

        public StatementSpec param(String var1, @Nullable Object var2, int var3);

        public StatementSpec params(Object ... var1);

        public StatementSpec params(List<?> var1);

        public StatementSpec params(Map<String, ?> var1);

        public StatementSpec paramSource(Object var1);

        public StatementSpec paramSource(SqlParameterSource var1);

        public ResultQuerySpec query();

        public <T> MappedQuerySpec<T> query(Class<T> var1);

        public <T> MappedQuerySpec<T> query(RowMapper<T> var1);

        public void query(RowCallbackHandler var1);

        public <T> T query(ResultSetExtractor<T> var1);

        public int update();

        public int update(KeyHolder var1);

        public int update(KeyHolder var1, String ... var2);
    }
}

