/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public abstract class AbstractNamedValueArgumentResolver
implements HttpServiceArgumentResolver {
    private static final TypeDescriptor STRING_TARGET_TYPE = TypeDescriptor.valueOf(String.class);
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private final ConversionService conversionService;
    private final Map<MethodParameter, NamedValueInfo> namedValueInfoCache = new ConcurrentHashMap<MethodParameter, NamedValueInfo>(256);

    protected AbstractNamedValueArgumentResolver(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService is required");
        this.conversionService = conversionService;
    }

    protected AbstractNamedValueArgumentResolver() {
        this.conversionService = null;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        NamedValueInfo info = this.getNamedValueInfo(parameter, requestValues);
        if (info == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(parameter.getParameterType())) {
            Assert.isInstanceOf(Map.class, argument);
            parameter = parameter.nested(1);
            argument = argument != null ? argument : Collections.emptyMap();
            for (Map.Entry entry : argument.entrySet()) {
                this.addSingleOrMultipleValues((String)entry.getKey(), entry.getValue(), false, null, info.label, info.multiValued, parameter, requestValues);
            }
        } else {
            this.addSingleOrMultipleValues(info.name, argument, info.required, info.defaultValue, info.label, info.multiValued, parameter, requestValues);
        }
        return true;
    }

    @Nullable
    private NamedValueInfo getNamedValueInfo(MethodParameter parameter, HttpRequestValues.Metadata requestValues) {
        NamedValueInfo info = this.namedValueInfoCache.get(parameter);
        if (info == null) {
            info = this.createNamedValueInfo(parameter, requestValues);
            if (info == null) {
                return null;
            }
            info = this.updateNamedValueInfo(parameter, info);
            this.namedValueInfoCache.put(parameter, info);
        }
        return info;
    }

    @Nullable
    protected abstract NamedValueInfo createNamedValueInfo(MethodParameter var1);

    @Nullable
    protected NamedValueInfo createNamedValueInfo(MethodParameter parameter, HttpRequestValues.Metadata metadata) {
        return this.createNamedValueInfo(parameter);
    }

    private NamedValueInfo updateNamedValueInfo(MethodParameter parameter, NamedValueInfo info) {
        String name = info.name;
        if (info.name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument of type [%s] not specified, and parameter name information not available via reflection. Ensure that the compiler uses the '-parameters' flag.".formatted(parameter.getNestedParameterType().getName()));
        }
        boolean required = info.required && !parameter.isOptional();
        String defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(info.defaultValue) ? null : info.defaultValue;
        return info.update(name, required, defaultValue);
    }

    private void addSingleOrMultipleValues(String name, @Nullable Object value, boolean required, @Nullable Object defaultValue, String valueLabel, boolean supportsMultiValues, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (supportsMultiValues) {
            if (ObjectUtils.isArray(value)) {
                value = Arrays.asList((Object[])value);
            }
            if (value instanceof Collection) {
                Collection elements = value;
                parameter = parameter.nested();
                boolean hasValues = false;
                for (Object element : elements) {
                    if (element == null) continue;
                    hasValues = true;
                    this.addSingleValue(name, element, false, null, valueLabel, parameter, requestValues);
                }
                if (hasValues) {
                    return;
                }
                value = null;
            }
        }
        this.addSingleValue(name, value, required, defaultValue, valueLabel, parameter, requestValues);
    }

    private void addSingleValue(String name, @Nullable Object value, boolean required, @Nullable Object defaultValue, String valueLabel, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            value = optionalValue.orElse(null);
        }
        if (value == null && defaultValue != null) {
            value = defaultValue;
        }
        if (this.conversionService != null && !(value instanceof String)) {
            Object beforeValue = value;
            Class<?> type = (parameter = parameter.nestedIfOptional()).getNestedParameterType();
            Object object = value = type != Object.class && !type.isArray() ? this.conversionService.convert(value, new TypeDescriptor(parameter), STRING_TARGET_TYPE) : this.conversionService.convert(value, String.class);
            if (!StringUtils.hasText((String)value) && !required && beforeValue == null) {
                value = null;
            }
        }
        if (value == null) {
            Assert.isTrue(!required, () -> "Missing " + valueLabel + " value '" + name + "'");
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Resolved " + valueLabel + " value '" + name + ":" + String.valueOf(value) + "'"));
        }
        this.addRequestValue(name, value, parameter, requestValues);
    }

    protected abstract void addRequestValue(String var1, Object var2, MethodParameter var3, HttpRequestValues.Builder var4);

    protected static class NamedValueInfo {
        private final String name;
        private final boolean required;
        @Nullable
        private final String defaultValue;
        private final String label;
        private final boolean multiValued;

        public NamedValueInfo(String name, boolean required, @Nullable String defaultValue, String label, boolean multiValued) {
            this.name = name;
            this.required = required;
            this.defaultValue = defaultValue;
            this.label = label;
            this.multiValued = multiValued;
        }

        public NamedValueInfo update(String name, boolean required, @Nullable String defaultValue) {
            return new NamedValueInfo(name, required, defaultValue, this.label, this.multiValued);
        }
    }
}

