/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.monitoring;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cluster.monitoring.spi.model.Table;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.Supplier;

public class CacheStatisticSupplier
implements Supplier<Table<String, String, String, String, List<String>>> {
    private static final String I18N_PREFIX = CacheStatisticSupplier.class.getCanonicalName();
    private final I18NBeanFactory i18NBeanFactory;
    private final CacheManager cacheManager;

    public CacheStatisticSupplier(CacheManager cacheManager, I18NBeanFactory i18NBeanFactory) {
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @Override
    public Table<String, String, String, String, List<String>> get() {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        LinkedHashMap<String, List<String>> rows = new LinkedHashMap<String, List<String>>();
        for (ManagedCache cache : this.cacheManager.getManagedCaches()) {
            rows.put(cache.getName(), this.getRowValues(cache, i18NBean));
        }
        return new Table(CacheStatisticSupplier.getColumns(i18NBean), rows);
    }

    private List<String> getRowValues(ManagedCache cache, I18NBean i18NBean) {
        SortedMap stats = cache.getStatistics();
        String displayableName = this.getDisplayableName(cache.getName(), i18NBean);
        Long size = this.fetchCacheValue(stats, CacheStatisticsKey.SIZE);
        Long hitCount = this.fetchCacheValue(stats, CacheStatisticsKey.HIT_COUNT);
        Long missCount = this.fetchCacheValue(stats, CacheStatisticsKey.MISS_COUNT);
        Long hitPercentage = hitCount == null || missCount == null || hitCount + missCount == 0L ? null : Long.valueOf(100L * hitCount / (hitCount + missCount));
        return List.of(displayableName, String.valueOf(size), String.valueOf(hitCount), String.valueOf(missCount), hitPercentage == null ? "null" : hitPercentage + "%");
    }

    private static Map<String, String> getColumns(I18NBean i18NBean) {
        return Map.of(Column.NAME.key, i18NBean.getText(Column.NAME.i18nKey), Column.SIZE.key, i18NBean.getText(Column.SIZE.i18nKey), Column.HIT_COUNT.key, i18NBean.getText(Column.HIT_COUNT.i18nKey), Column.MISS_COUNT.key, i18NBean.getText(Column.MISS_COUNT.i18nKey), Column.HIT_PERCENT.key, i18NBean.getText(Column.HIT_PERCENT.i18nKey));
    }

    private String getDisplayableName(String cacheName, I18NBean i18NBean) {
        String i18nValue;
        String i18nKey = "cache.name." + cacheName.replace("_v5", "");
        return i18nKey.equals(i18nValue = i18NBean.getText(i18nKey)) ? cacheName : i18nValue;
    }

    private Long fetchCacheValue(Map<CacheStatisticsKey, Supplier<Long>> stats, CacheStatisticsKey key) {
        Supplier<Long> longSupplier = stats.get(key);
        return longSupplier == null ? null : longSupplier.get();
    }

    private static enum Column {
        NAME("name"),
        SIZE("size"),
        HIT_COUNT("hitCount"),
        MISS_COUNT("missCount"),
        HIT_PERCENT("hitPercent");

        private final String key;
        private final String i18nKey;

        private Column(String key) {
            this.key = Objects.requireNonNull(key);
            this.i18nKey = I18N_PREFIX + "." + this.key;
        }
    }
}

