/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.confluence.setup.bandana.BandanaPersisterSupport;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaRecord;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.atlassian.confluence.setup.bandana.persistence.dao.ConfluenceBandanaRecordDao;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceDaoBandanaPersister
implements BandanaPersister {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceDaoBandanaPersister.class);
    private ConfluenceBandanaRecordDao dao;
    private BandanaPersisterSupport support;

    @Override
    public Object retrieve(BandanaContext context, String key) {
        ConfluenceBandanaRecord record = this.dao.getRecord(ConfluenceDaoBandanaPersister.toContextKey(context), key);
        return record == null ? null : this.getObjectFromValue(record, context);
    }

    @Override
    public Map<String, Object> retrieve(BandanaContext context) {
        Collection<ConfluenceBandanaRecord> c = this.dao.findForContext(ConfluenceDaoBandanaPersister.toContextKey(context));
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (ConfluenceBandanaRecord r : c) {
            Object o = this.getObjectFromValue(r, context);
            if (o == null) continue;
            m.put(r.getKey(), o);
        }
        return m;
    }

    @Override
    public Iterable<String> retrieveKeys(BandanaContext bandanaContext) {
        return this.dao.findKeysForContext(ConfluenceDaoBandanaPersister.toContextKey(bandanaContext));
    }

    @Override
    public void store(BandanaContext context, String key, Object value) {
        StringWriter objectData = new StringWriter();
        try {
            this.support.getSerializer(context).serialize(value, objectData);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize object data", e);
        }
        this.dao.saveOrUpdate(new ConfluenceBandanaRecord(ConfluenceDaoBandanaPersister.toContextKey(context), key, objectData.toString()));
    }

    @Override
    public void flushCaches() {
    }

    @Override
    public void remove(BandanaContext context) {
        this.dao.removeAllInContext(ConfluenceDaoBandanaPersister.toContextKey(context));
    }

    @Override
    public void remove(BandanaContext context, String key) {
        this.dao.remove(new ConfluenceBandanaRecord(ConfluenceDaoBandanaPersister.toContextKey(context), key, null));
    }

    private Object getObjectFromValue(ConfluenceBandanaRecord record, BandanaContext context) {
        try {
            return this.support.getSerializer(context).deserialize(new StringReader(record.getValue()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize object data", e);
        }
        catch (Exception e) {
            log.debug("Configuration could not be loaded because class could not be found (context: {}, key: {}).\n{}: {}", new Object[]{record.getContext(), record.getKey(), e.getClass().getName(), e.getMessage(), e});
            return null;
        }
    }

    public void setConfluenceBandanaRecordDao(ConfluenceBandanaRecordDao dao) {
        this.dao = dao;
    }

    public void setBandanaPersisterSupport(BandanaPersisterSupport support) {
        this.support = support;
    }

    private static String toContextKey(BandanaContext context) {
        if (!(context instanceof KeyedBandanaContext)) {
            throw new ClassCastException("Expected KeyedBandanaContext but got: " + String.valueOf(context.getClass()));
        }
        KeyedBandanaContext keyedBandanaContext = (KeyedBandanaContext)context;
        return keyedBandanaContext.getContextKey();
    }
}

