/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createjiracontent.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.plugins.createjiracontent.services.FeatureDiscoveryService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import jakarta.inject.Inject;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="metadata")
@Produces(value={"application/json"})
public class CreateIssueMetadataResource {
    private final FeatureDiscoveryService featureDiscoveryService;

    @Inject
    public CreateIssueMetadataResource(FeatureDiscoveryService featureDiscoveryService) {
        this.featureDiscoveryService = featureDiscoveryService;
    }

    @Path(value="/discovered")
    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response setDiscovered() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        this.featureDiscoveryService.setUserDiscovered(user, true);
        return Response.ok().build();
    }
}

