/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.multipart.fileupload;

import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.v2.multipart.exception.UnsupportedFileNameEncodingException;
import jakarta.mail.internet.MimeUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.apache.commons.fileupload2.core.FileItem;

public final class CommonsFileUploadFilePart
implements FilePart {
    private final FileItem fileItem;
    private final String name;

    CommonsFileUploadFilePart(FileItem fileItem) {
        this.fileItem = Objects.requireNonNull(fileItem);
        try {
            this.name = fileItem.getName() == null ? null : new File(MimeUtility.decodeText((String)fileItem.getName())).getName();
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedFileNameEncodingException(fileItem.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public void write(File file) throws IOException {
        try {
            this.fileItem.write(file.toPath());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public String getValue() {
        try {
            return this.fileItem.getString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read file item", e);
        }
    }

    public boolean isFormField() {
        return this.fileItem.isFormField();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }
}

