/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.oauth2;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.oauth.auth.oauth2.OAuth2Request;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOAuth2RequestFactory
implements ApplicationLinkRequestFactory {
    public static final int TOKEN_EXPIRE_MARGIN = 30;
    protected final ApplicationLink applicationLink;
    protected final RequestFactory requestFactory;
    protected final TokenHandler tokenHandler;
    protected final Cache<AccessTokenKey, OAuth2Token> accessTokenCache;

    public AbstractOAuth2RequestFactory(ApplicationLink applicationLink, RequestFactory requestFactory, TokenHandler tokenHandler, Cache<AccessTokenKey, OAuth2Token> accessTokenCache) {
        this.applicationLink = Objects.requireNonNull(applicationLink);
        this.requestFactory = Objects.requireNonNull(requestFactory);
        this.tokenHandler = tokenHandler;
        this.accessTokenCache = accessTokenCache;
    }

    public static Cache<AccessTokenKey, OAuth2Token> createDefaultAccessTokenCache(CacheFactory cacheFactory, String cacheName) {
        return cacheFactory.getCache(cacheName, null, new CacheSettingsBuilder().local().expireAfterWrite(30L, TimeUnit.MINUTES).build());
    }

    public ApplicationLinkRequest createRequest(Request.MethodType methodType, String uri) throws CredentialsRequiredException {
        Request request = this.requestFactory.createRequest(methodType, uri);
        return new OAuth2Request(uri, request, this.retrieveAccessToken(), this.getAccessTokenKey(), this.accessTokenCache, this.tokenHandler);
    }

    private boolean isTokenExpired(OAuth2Token oAuth2Token) {
        return oAuth2Token.getAccessTokenExpiration().minus(Duration.ofSeconds(30L)).isBefore(Clock.systemUTC().instant());
    }

    protected AccessTokenKey getAccessTokenKey() {
        return new AccessTokenKey(this.getExternalId(), this.getClientConfigurationId());
    }

    public String retrieveAccessToken() throws CredentialsRequiredException {
        OAuth2Token oAuth2Token = (OAuth2Token)this.accessTokenCache.get((Object)this.getAccessTokenKey());
        if (oAuth2Token == null || this.isTokenExpired(oAuth2Token)) {
            oAuth2Token = this.refreshAccessToken();
            this.accessTokenCache.put((Object)this.getAccessTokenKey(), (Object)oAuth2Token);
        }
        return oAuth2Token.getAccessToken();
    }

    protected abstract OAuth2Token refreshAccessToken() throws CredentialsRequiredException;

    protected abstract String getClientConfigurationId();

    protected abstract String getExternalId();
}

