/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.oauth2;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.internal.common.auth.oauth.OAuthMessageProblemException;
import com.atlassian.applinks.internal.common.net.AuthenticationAwareApplicationLinkResponseHandler;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.oauth.auth.oauth2.BaseOAuth2ApplicationLinkResponseHandler;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class OAuth2AuthenticationAwareResponseHandler<R>
extends BaseOAuth2ApplicationLinkResponseHandler
implements AuthenticationAwareApplicationLinkResponseHandler<R> {
    private final AuthenticationAwareApplicationLinkResponseHandler<R> applicationLinkResponseHandler;

    public OAuth2AuthenticationAwareResponseHandler(String url, ApplicationLinkResponseHandler<R> applicationLinkResponseHandler, ApplicationLinkRequest wrappedRequest, boolean followRedirects, AccessTokenKey accessTokenKey, String accessToken, Cache<AccessTokenKey, OAuth2Token> accessTokenCache, TokenHandler tokenHandler) {
        super(url, wrappedRequest, followRedirects, accessTokenKey, accessToken, accessTokenCache, tokenHandler);
        this.applicationLinkResponseHandler = this.getAuthenticationAwareApplicationLinkResponseHandler(applicationLinkResponseHandler);
    }

    public R credentialsRequired(Response response) throws ResponseException {
        return (R)this.applicationLinkResponseHandler.credentialsRequired(response);
    }

    @Nonnull
    public R credentialsRequired(@Nonnull Response response, @Nullable String problem, @Nullable String problemAdvice) throws ResponseException {
        return (R)this.applicationLinkResponseHandler.credentialsRequired(response, problem, problemAdvice);
    }

    @Nonnull
    public R authenticationFailed(@Nonnull Response response, @Nullable String problem, @Nullable String problemAdvice) throws ResponseException {
        return (R)this.applicationLinkResponseHandler.authenticationFailed(response, problem, problemAdvice);
    }

    public R handle(Response response) throws ResponseException {
        this.validateResponse(response);
        if (this.credentialsRequired) {
            return (R)this.applicationLinkResponseHandler.credentialsRequired(response, this.authenticationProblem, this.authenticationProblemAdvice);
        }
        if (this.authenticationProblem != null) {
            return (R)this.applicationLinkResponseHandler.authenticationFailed(response, this.authenticationProblem, this.authenticationProblemAdvice);
        }
        if (this.followRedirects && this.redirectHelper.responseShouldRedirect(response)) {
            this.wrappedRequest.setUrl(this.redirectHelper.getNextRedirectLocation(response));
            return (R)this.wrappedRequest.execute((ApplicationLinkResponseHandler)this);
        }
        return (R)this.applicationLinkResponseHandler.handle(response);
    }

    private AuthenticationAwareApplicationLinkResponseHandler<R> getAuthenticationAwareApplicationLinkResponseHandler(final ApplicationLinkResponseHandler<R> applicationLinkResponseHandler) {
        return new AuthenticationAwareApplicationLinkResponseHandler<R>(){

            @Nonnull
            public R authenticationFailed(@Nonnull Response response, @Nullable String reason, @Nullable String authenticationProblemAdvice) throws ResponseException {
                if (AuthenticationAwareApplicationLinkResponseHandler.class.isInstance(applicationLinkResponseHandler)) {
                    return ((AuthenticationAwareApplicationLinkResponseHandler)applicationLinkResponseHandler).authenticationFailed(response, reason, authenticationProblemAdvice);
                }
                throw new OAuthMessageProblemException("OAuth authentication failed: " + reason, reason, authenticationProblemAdvice, null);
            }

            public R credentialsRequired(Response response) throws ResponseException {
                return applicationLinkResponseHandler.credentialsRequired(response);
            }

            @Nonnull
            public R credentialsRequired(@Nonnull Response response, @Nullable String problem, @Nullable String problemAdvice) throws ResponseException {
                if (AuthenticationAwareApplicationLinkResponseHandler.class.isAssignableFrom(applicationLinkResponseHandler.getClass())) {
                    return ((AuthenticationAwareApplicationLinkResponseHandler)applicationLinkResponseHandler).credentialsRequired(response, problem, problemAdvice);
                }
                return applicationLinkResponseHandler.credentialsRequired(response);
            }

            public R handle(Response response) throws ResponseException {
                return applicationLinkResponseHandler.handle(response);
            }
        };
    }
}

