/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.oauth2;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.AbstractApplicationLinkRequest;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.oauth.auth.oauth2.OAuth2AuthenticationAwareResponseHandler;
import com.atlassian.applinks.oauth.auth.oauth2.OAuth2ResponseHandler;
import com.atlassian.applinks.oauth.auth.oauth2.OAuth2ReturningResponseHandler;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ReturningResponseHandler;

public class OAuth2Request
extends AbstractApplicationLinkRequest {
    private final String accessToken;
    private final Cache<AccessTokenKey, OAuth2Token> accessTokenCache;
    private final TokenHandler tokenHandler;
    private final AccessTokenKey accessTokenKey;

    public OAuth2Request(String url, Request wrappedRequest, String accessToken, AccessTokenKey accessTokenKey, Cache<AccessTokenKey, OAuth2Token> accessTokenCache, TokenHandler tokenHandler) {
        super(url, wrappedRequest);
        this.accessToken = accessToken;
        this.accessTokenCache = accessTokenCache;
        this.accessTokenKey = accessTokenKey;
        this.tokenHandler = tokenHandler;
    }

    protected void signRequest() {
        this.wrappedRequest.setHeader("Authorization", "Bearer " + this.accessToken);
    }

    public <R> R execute(ApplicationLinkResponseHandler<R> responseHandler) throws ResponseException {
        this.signRequest();
        return (R)this.wrappedRequest.execute(new OAuth2AuthenticationAwareResponseHandler<R>(this.url, responseHandler, (ApplicationLinkRequest)this, true, this.accessTokenKey, this.accessToken, this.accessTokenCache, this.tokenHandler));
    }

    public void execute(ResponseHandler responseHandler) throws ResponseException {
        this.signRequest();
        this.wrappedRequest.execute(this.ensureOAuth2ResponseHandler(responseHandler));
    }

    private ResponseHandler ensureOAuth2ResponseHandler(ResponseHandler responseHandler) {
        if (responseHandler instanceof OAuth2ResponseHandler) {
            return responseHandler;
        }
        return new OAuth2ResponseHandler(this.url, (ResponseHandler<Response>)responseHandler, (ApplicationLinkRequest)this, this.followRedirects, this.accessTokenKey, this.accessToken, this.accessTokenCache, this.tokenHandler);
    }

    public <R> R executeAndReturn(ReturningResponseHandler<? super Response, R> responseHandler) throws ResponseException {
        this.signRequest();
        return (R)this.wrappedRequest.executeAndReturn(this.ensureOAuth2ApplinksReturningResponseHandler(responseHandler));
    }

    private <R> ReturningResponseHandler<? super Response, R> ensureOAuth2ApplinksReturningResponseHandler(ReturningResponseHandler<? super Response, R> returningResponseHandler) {
        if (returningResponseHandler instanceof OAuth2ReturningResponseHandler) {
            return returningResponseHandler;
        }
        return new OAuth2ReturningResponseHandler<R>(this.url, returningResponseHandler, (ApplicationLinkRequest)this, this.followRedirects, this.accessTokenKey, this.accessToken, this.accessTokenCache, this.tokenHandler);
    }
}

