/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.oauth2;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.oauth.auth.oauth2.BaseOAuth2ApplicationLinkResponseHandler;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;

public class OAuth2ResponseHandler
extends BaseOAuth2ApplicationLinkResponseHandler
implements ResponseHandler<Response> {
    private final ResponseHandler<Response> responseHandler;

    public OAuth2ResponseHandler(String url, ResponseHandler<Response> responseHandler, ApplicationLinkRequest wrappedRequest, boolean followRedirects, AccessTokenKey accessTokenKey, String accessToken, Cache<AccessTokenKey, OAuth2Token> accessTokenCache, TokenHandler tokenHandler) {
        super(url, wrappedRequest, followRedirects, accessTokenKey, accessToken, accessTokenCache, tokenHandler);
        this.responseHandler = responseHandler;
    }

    public void handle(Response response) throws ResponseException {
        this.validateResponse(response);
        if (this.followRedirects && this.redirectHelper.responseShouldRedirect(response)) {
            this.wrappedRequest.setUrl(this.redirectHelper.getNextRedirectLocation(response));
            this.wrappedRequest.execute((ResponseHandler)this);
        } else {
            this.responseHandler.handle(response);
        }
    }
}

