/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.oauth2;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.oauth.auth.oauth2.BaseOAuth2ApplicationLinkResponseHandler;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;

public class OAuth2ReturningResponseHandler<R>
extends BaseOAuth2ApplicationLinkResponseHandler
implements ReturningResponseHandler<Response, R> {
    private ReturningResponseHandler<? super Response, R> responseHandler;

    public OAuth2ReturningResponseHandler(String url, ReturningResponseHandler<? super Response, R> responseHandler, ApplicationLinkRequest wrappedRequest, boolean followRedirects, AccessTokenKey accessTokenKey, String accessToken, Cache<AccessTokenKey, OAuth2Token> accessTokenCache, TokenHandler tokenHandler) {
        super(url, wrappedRequest, followRedirects, accessTokenKey, accessToken, accessTokenCache, tokenHandler);
        this.responseHandler = responseHandler;
    }

    public R handle(Response response) throws ResponseException {
        this.validateResponse(response);
        if (this.followRedirects && this.redirectHelper.responseShouldRedirect(response)) {
            this.wrappedRequest.setUrl(this.redirectHelper.getNextRedirectLocation(response));
            return (R)this.wrappedRequest.executeAndReturn((ReturningResponseHandler)this);
        }
        return (R)this.responseHandler.handle(response);
    }
}

