/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.servlets;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequest;
import com.atlassian.oauth2.client.api.lib.flow.FlowRequestService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.user.UserManager;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;

@UnrestrictedAccess
public class OAuth2FlowRequestServlet
extends HttpServlet {
    public static final String APPLINK_ID = "applinkId";
    public static final String REDIRECT_URI = "redirectUri";
    private final ApplicationLinkService applicationLinkService;
    private final UserManager userManager;
    private final FlowRequestService flowRequestService;
    private final ApplicationProperties applicationProperties;
    private final PermissionEnforcer permissionEnforcer;

    public OAuth2FlowRequestServlet(ApplicationLinkService applicationLinkService, UserManager userManager, FlowRequestService flowRequestService, ApplicationProperties applicationProperties, PermissionEnforcer permissionEnforcer) {
        this.applicationLinkService = applicationLinkService;
        this.userManager = userManager;
        this.flowRequestService = flowRequestService;
        this.applicationProperties = applicationProperties;
        this.permissionEnforcer = permissionEnforcer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationLink applicationLink;
        this.permissionEnforcer.enforceAuthenticated();
        String applinkId = Objects.requireNonNull(req.getParameter(APPLINK_ID));
        String redirectUri = req.getParameter(REDIRECT_URI);
        try {
            applicationLink = this.getApplicationLink(applinkId);
        }
        catch (TypeNotInstalledException e) {
            throw new RuntimeException(e);
        }
        String clientConfigurationId = applicationLink.getAuthorizationCodeClientConfigurationId();
        FlowRequest flowRequest = this.flowRequestService.createFlowRequest(req.getSession(), clientConfigurationId, this.userManager.getRemoteUser().getUsername(), callback -> redirectUri == null ? this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) : redirectUri);
        resp.sendRedirect(flowRequest.getInitFlowUrl());
    }

    private ApplicationLink getApplicationLink(String applinkId) throws TypeNotInstalledException {
        return this.applicationLinkService.getApplicationLink(new ApplicationId(applinkId));
    }
}

