/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.threelo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.oauth.auth.oauth2.AbstractOAuth2RequestFactory;
import com.atlassian.applinks.oauth.auth.threelo.ThreeLeggedOAuth2RequestFactoryImpl;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.auth.AuthenticationDirection;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.auth.IncomingTrustAuthenticationProviderPluginModule;
import com.atlassian.cache.CacheFactory;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Version;

public class ThreeLeggedOAuth2AuthenticatorProviderPluginModule
implements AuthenticationProviderPluginModule,
IncomingTrustAuthenticationProviderPluginModule {
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final RequestFactory requestFactory;
    private final UserManager userManager;
    private final TokenHandler tokenHandler;
    private final ApplicationProperties applicationProperties;
    private final CacheFactory cacheFactory;

    public ThreeLeggedOAuth2AuthenticatorProviderPluginModule(AuthenticationConfigurationManager authenticationConfigurationManager, RequestFactory requestFactory, UserManager userManager, TokenHandler tokenHandler, ApplicationProperties applicationProperties, CacheFactory applinksRequestCache) {
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.requestFactory = requestFactory;
        this.userManager = userManager;
        this.tokenHandler = tokenHandler;
        this.applicationProperties = applicationProperties;
        this.cacheFactory = applinksRequestCache;
    }

    public AuthenticationProvider getAuthenticationProvider(ApplicationLink link) {
        ThreeLeggedOAuth2AuthenticationProvider provider = null;
        if (this.authenticationConfigurationManager.isConfigured(link.getId(), ThreeLeggedOAuth2AuthenticationProvider.class)) {
            provider = username -> new ThreeLeggedOAuth2RequestFactoryImpl(link, this.authenticationConfigurationManager, this.userManager, this.requestFactory, this.tokenHandler, this.applicationProperties, AbstractOAuth2RequestFactory.createDefaultAccessTokenCache(this.cacheFactory, ThreeLeggedOAuth2RequestFactoryImpl.ACCESS_TOKEN_CACHE));
        }
        return provider;
    }

    public boolean incomingEnabled(ApplicationLink applicationLink) {
        return StringUtils.isNotBlank((CharSequence)applicationLink.getClientId());
    }

    public String getConfigUrl(ApplicationLink link, Version applicationLinksVersion, AuthenticationDirection direction, HttpServletRequest request) {
        return null;
    }

    public Class<? extends AuthenticationProvider> getAuthenticationProviderClass() {
        return ThreeLeggedOAuth2AuthenticationProvider.class;
    }
}

