/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.auth.twolo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.oauth.auth.oauth2.AbstractOAuth2RequestFactory;
import com.atlassian.applinks.oauth.auth.oauth2.AccessTokenKey;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.cache.Cache;
import com.atlassian.oauth2.client.api.OAuth2Token;
import com.atlassian.oauth2.client.api.storage.ClientCredentialsTokenHandler;
import com.atlassian.oauth2.client.api.storage.TokenHandler;
import com.atlassian.oauth2.client.api.storage.token.exception.RecoverableTokenException;
import com.atlassian.oauth2.client.api.storage.token.exception.UnrecoverableTokenException;
import com.atlassian.sal.api.net.RequestFactory;
import java.net.URI;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoLeggedOAuth2RequestFactoryImpl
extends AbstractOAuth2RequestFactory {
    private static final Logger log = LoggerFactory.getLogger(TwoLeggedOAuth2RequestFactoryImpl.class);
    public static final String ACCESS_TOKEN_CACHE = TwoLeggedOAuth2RequestFactoryImpl.class.getSimpleName() + ".accessTokenCache";
    private final ClientCredentialsTokenHandler clientCredentialsTokenHandler;

    public TwoLeggedOAuth2RequestFactoryImpl(ApplicationLink applicationLink, AuthenticationConfigurationManager authenticationConfigurationManager, RequestFactory requestFactory, TokenHandler tokenHandler, ClientCredentialsTokenHandler clientCredentialsTokenHandler, Cache<AccessTokenKey, OAuth2Token> accessTokenCache) {
        super(applicationLink, requestFactory, tokenHandler, accessTokenCache);
        this.clientCredentialsTokenHandler = clientCredentialsTokenHandler;
        boolean configured = authenticationConfigurationManager.isConfigured(applicationLink.getId(), TwoLeggedOAuth2AuthenticationProvider.class);
        if (!configured) {
            throw new IllegalStateException(String.format("OAuth2 Authentication is not configured for application link %s", applicationLink));
        }
    }

    @Override
    protected OAuth2Token refreshAccessToken() {
        try {
            OAuth2Token oAuth2Token = this.clientCredentialsTokenHandler.getClientCredentialsToken(this.getExternalId(), this.getClientConfigurationId(), Duration.ofSeconds(30L));
            log.info("Successfully refreshed access token");
            return oAuth2Token;
        }
        catch (RecoverableTokenException | UnrecoverableTokenException e) {
            log.error("Failed to refresh access token", e);
            throw new RuntimeException("Failed to refresh client_credentials token", e);
        }
    }

    public URI getAuthorisationURI(URI callback) {
        return null;
    }

    public URI getAuthorisationURI() {
        return null;
    }

    @Override
    protected String getClientConfigurationId() {
        return this.applicationLink.getClientCredentialsClientConfigurationId();
    }

    @Override
    protected String getExternalId() {
        return this.applicationLink.getClientId();
    }
}

