/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.oauth.rest;

import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksFilterBinding;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.common.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.internal.common.rest.util.RestApplicationIdParser;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="consumer-token")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@AdminApplicationLinksFilterBinding
@AdminOnly
public class ConsumerTokenResource {
    private final ConsumerTokenStoreService consumerTokenStoreService;
    private final UserManager userManager;

    @Inject
    public ConsumerTokenResource(ConsumerTokenStoreService consumerTokenStoreService, UserManager userManager) {
        this.consumerTokenStoreService = consumerTokenStoreService;
        this.userManager = userManager;
    }

    @DELETE
    @Path(value="{id}")
    public Response removeConsumerToken(@PathParam(value="id") String id) {
        if (this.userManager.getRemoteUserKey() != null) {
            this.consumerTokenStoreService.removeConsumerToken(RestApplicationIdParser.parseApplicationId((String)id), this.userManager.getRemoteUser().getUsername());
            return RestUtil.noContent();
        }
        return RestUtil.unauthorized((String)"User is not authorized");
    }
}

