/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.darkfeatures.rest;

import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.UnknownFeatureException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DarkFeatureUserResource {
    private final DarkFeaturesManager darkFeaturesManager;

    @Inject
    public DarkFeatureUserResource(@ComponentImport DarkFeaturesManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }

    @POST
    public Response enableFeatures(String[] featureKeys) throws UnknownFeatureException {
        for (String featureKey : featureKeys) {
            this.darkFeaturesManager.enableUserFeature(featureKey);
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Deprecated
    @PUT
    @Path(value="/{featureKeys}")
    public Response enableFeatures(@PathParam(value="featureKeys") String featureKeys) throws UnknownFeatureException {
        return this.enableFeatures(featureKeys.split(","));
    }

    @DELETE
    @Path(value="/{featureKeys}")
    public Response disableFeatures(@PathParam(value="featureKeys") String featureKeys) throws UnknownFeatureException {
        for (String featureKey : featureKeys.split(",")) {
            this.darkFeaturesManager.disableUserFeature(featureKey);
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/{featureKey}")
    public Response getFeature(@PathParam(value="featureKey") String featureKey) {
        DarkFeatures darkFeatures = this.darkFeaturesManager.getDarkFeatures();
        return darkFeatures.isFeatureEnabled(featureKey) ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

