/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.spi;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.spi.StreamsFilterOptionProvider;
import java.util.function.Function;

public final class ActivityOptions {
    private ActivityOptions() {
    }

    public static Function<Pair<ActivityObjectType, ActivityVerb>, StreamsFilterOptionProvider.ActivityOption> toActivityOptionFunc(I18nResolver i18nResolver, String messageKeyPrefix) {
        return new ToActivityOption(i18nResolver, messageKeyPrefix);
    }

    private static final class ToActivityOption
    implements Function<Pair<ActivityObjectType, ActivityVerb>, StreamsFilterOptionProvider.ActivityOption> {
        private final I18nResolver i18nResolver;
        private final String messageKeyPrefix;

        public ToActivityOption(I18nResolver i18nResolver, String messageKeyPrefix) {
            this.i18nResolver = i18nResolver;
            this.messageKeyPrefix = messageKeyPrefix;
        }

        @Override
        public StreamsFilterOptionProvider.ActivityOption apply(Pair<ActivityObjectType, ActivityVerb> a) {
            String name = this.i18nResolver.getText(this.messageKeyPrefix + "." + ((ActivityObjectType)a.first()).key() + "." + ((ActivityVerb)a.second()).key());
            return new StreamsFilterOptionProvider.ActivityOption(name, (ActivityObjectType)a.first(), (ActivityVerb)a.second());
        }
    }
}

