/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.spi;

import com.atlassian.streams.api.ActivityObjectType;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerb;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.StreamsFilterType;
import com.atlassian.streams.api.common.Fold;
import com.atlassian.streams.api.common.Function2;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.api.common.Pair;
import com.atlassian.streams.api.common.Pairs;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Filters {
    private static final Function<Long, Date> toDate = Date::new;

    @Deprecated
    public static Predicate<String> isAndNot(Iterable<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        return Filters.isAndNot(filters, Filters.isIn(), Filters.notIn());
    }

    public static Predicate<String> isAndNot(Iterable<Pair<StreamsFilterType.Operator, Iterable<String>>> filters, Function<Iterable<String>, Predicate<String>> is, Function<Iterable<String>, Predicate<String>> not) {
        com.google.common.base.Predicate alwaysTrue = Predicates.alwaysTrue();
        if (filters == null) {
            return alwaysTrue;
        }
        return (Predicate)Fold.foldl(filters, (Object)alwaysTrue, (Function2)new IsAndNot(is, not));
    }

    @Deprecated
    public static Function<Iterable<String>, Predicate<String>> isIn() {
        return IsIn.INSTANCE;
    }

    @Deprecated
    public static Function<Iterable<String>, Predicate<String>> notIn() {
        return NotIn.INSTANCE;
    }

    @Deprecated
    public static Predicate<Iterable<String>> anyInUsers(ActivityRequest request) {
        if (Iterables.isEmpty(Filters.getIsValues(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.USER.getKey(), Collections.emptyList())))) {
            return Predicates.alwaysTrue();
        }
        return new AnyInUsers(request);
    }

    @Deprecated
    public static Predicate<String> inUsers(ActivityRequest request) {
        return Filters.isAndNot(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.USER.getKey(), Collections.emptyList()));
    }

    @Deprecated
    public static Predicate<Iterable<String>> notInUsers(ActivityRequest request) {
        return new NotInUsers(request);
    }

    @Deprecated
    public static Predicate<String> inProjectKeys(ActivityRequest request) {
        return Filters.isAndNot(request.getStandardFiltersMap().getOrDefault("key", Collections.emptyList()));
    }

    @Deprecated
    public static Predicate<String> inIssueKeys(ActivityRequest request) {
        return Filters.isAndNot(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.ISSUE_KEY.getKey(), Collections.emptyList()));
    }

    @Deprecated
    public static Predicate<String> inIssueKeys(ActivityRequest request, Function<Iterable<String>, Predicate<String>> is, Function<Iterable<String>, Predicate<String>> not) {
        return Filters.isAndNot(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.ISSUE_KEY.getKey(), Collections.emptyList()), is, not);
    }

    @Deprecated
    public static Predicate<Pair<ActivityObjectType, ActivityVerb>> inActivities(ActivityRequest request) {
        if (!Filters.providerFilterExists(request, "activity")) {
            return Predicates.alwaysTrue();
        }
        return new InActivities(request.getProviderFiltersMap().getOrDefault("activity", Collections.emptyList()));
    }

    @Deprecated
    public static Predicate<Option<Pair<ActivityObjectType, ActivityVerb>>> inOptionActivities(ActivityRequest request) {
        if (!Filters.providerFilterExists(request, "activity")) {
            return Predicates.alwaysTrue();
        }
        return new InOptionActivities(request.getProviderFiltersMap().getOrDefault("activity", Collections.emptyList()));
    }

    @Deprecated
    public static Predicate<StreamsEntry> entriesInActivities(ActivityRequest request) {
        if (!Filters.providerFilterExists(request, "activity")) {
            return Predicates.alwaysTrue();
        }
        return new EntriesInActivities(request.getProviderFiltersMap().getOrDefault("activity", Collections.emptyList()));
    }

    private static boolean providerFilterExists(ActivityRequest request, String filterKey) {
        Map providerFilters = request.getProviderFiltersMap();
        Collection fieldFilters = providerFilters.getOrDefault(filterKey, Collections.emptyList());
        return !fieldFilters.isEmpty();
    }

    public static Iterable<String> getAuthors(ActivityRequest request) {
        return Filters.getIsValues(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.USER.getKey(), Collections.emptyList()));
    }

    public static Iterable<String> getProjectKeys(ActivityRequest request) {
        return Filters.getIsValues(request.getStandardFiltersMap().getOrDefault("key", Collections.emptyList()));
    }

    public static Iterable<String> getNotProjectKeys(ActivityRequest request) {
        return Filters.getNotValues(request.getStandardFiltersMap().getOrDefault("key", Collections.emptyList()));
    }

    public static Iterable<String> getIssueKeys(ActivityRequest request) {
        return Filters.getIsValues(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.ISSUE_KEY.getKey(), Collections.emptyList()));
    }

    public static Iterable<String> getNotIssueKeys(ActivityRequest request) {
        return Filters.getNotValues(request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.ISSUE_KEY.getKey(), Collections.emptyList()));
    }

    public static Option<Date> getMinDate(ActivityRequest request) {
        Collection filters = request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.UPDATE_DATE.getKey(), Collections.emptyList());
        Option<Long> minDate = Filters.parseLongSafely(Filters.getFirstValue(StreamsFilterType.Operator.AFTER, filters));
        if (!minDate.isDefined() && Iterables.size((Iterable)filters) > 0) {
            return Filters.getDateRange(filters).map(Pair::first);
        }
        return minDate.map(toDate);
    }

    public static Iterable<ActivityObjectType> getRequestedActivityObjectTypes(ActivityRequest request, Iterable<Pair<ActivityObjectType, ActivityVerb>> activities) {
        return Pairs.firsts((Iterable)Iterables.filter(activities, Filters.inActivities(request)::test));
    }

    public static Option<Date> getMaxDate(ActivityRequest request) {
        Collection filters = request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.UPDATE_DATE.getKey(), Collections.emptyList());
        Option<Long> maxDate = Filters.parseLongSafely(Filters.getFirstValue(StreamsFilterType.Operator.BEFORE, filters));
        if (!maxDate.isDefined() && Iterables.size((Iterable)filters) > 0) {
            return Filters.getDateRange(filters).map(Pair::second);
        }
        return maxDate.map(toDate);
    }

    private static Option<Pair<Date, Date>> getDateRange(Collection<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        Pair firstFilter = (Pair)Iterables.get(filters, (int)0);
        Iterable dates = Iterables.transform((Iterable)((Iterable)firstFilter.second()), Filters::toDate);
        if (Iterables.size((Iterable)dates) < 2) {
            return Option.none();
        }
        Iterable ranges = Pairs.mkPairs((Iterable)dates);
        return Option.some((Object)((Pair)Iterables.get((Iterable)ranges, (int)0)));
    }

    private static Option<Long> parseLongSafely(Option<String> minDate) {
        Iterator iterator = minDate.iterator();
        if (iterator.hasNext()) {
            String min = (String)iterator.next();
            return Option.some((Object)Long.parseLong(min));
        }
        return Option.none();
    }

    @Deprecated
    public static Predicate<Date> inDateRange(ActivityRequest request) {
        com.google.common.base.Predicate alwaysTrue = Predicates.alwaysTrue();
        return (Predicate)Fold.foldl((Iterable)request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.UPDATE_DATE.getKey(), Collections.emptyList()), (Object)alwaysTrue, (Function2)ContainsDate.INSTANCE);
    }

    public static Set<String> getIsValues(Iterable<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        Pair<Set<String>, Set<String>> isAndNotValues = Filters.getIsAndNotValues(filters);
        return Sets.difference((Set)((Set)isAndNotValues.first()), (Set)((Set)isAndNotValues.second()));
    }

    public static Set<String> getNotValues(Iterable<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        Pair<Set<String>, Set<String>> isAndNotValues = Filters.getIsAndNotValues(filters);
        return (Set)isAndNotValues.second();
    }

    public static Pair<Set<String>, Set<String>> getIsAndNotValues(Iterable<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        Pair emptySets = Pair.pair((Object)ImmutableSet.of(), (Object)ImmutableSet.of());
        return (Pair)Fold.foldl(filters, (Object)emptySets, ExtractIsAndNotValues.INSTANCE::apply);
    }

    public static Date toDate(String date) {
        return new Date(Long.parseLong(date));
    }

    public static Iterable<String> getAllValues(StreamsFilterType.Operator op, Collection<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        return ((ImmutableList.Builder)Fold.foldl(filters, (Object)ImmutableList.builder(), (filter, builder) -> {
            if (((StreamsFilterType.Operator)filter.first()).equals((Object)op)) {
                builder.addAll((Iterable)filter.second());
            }
            return builder;
        })).build();
    }

    public static Option<String> getFirstValue(StreamsFilterType.Operator op, Iterable<Pair<StreamsFilterType.Operator, Iterable<String>>> filters) {
        try {
            Iterable values = StreamSupport.stream(filters.spliterator(), false).filter(Filters.withOp(op)).findFirst().map(Pair::second).orElse(Collections.emptyList());
            if (!Iterables.isEmpty((Iterable)values)) {
                return Option.some((Object)((String)Iterables.get((Iterable)values, (int)0)));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return Option.none();
    }

    private static Predicate<Pair<StreamsFilterType.Operator, Iterable<String>>> withOp(StreamsFilterType.Operator op) {
        return new WithOperator(op);
    }

    private static final class IsAndNot
    implements Function2<Pair<StreamsFilterType.Operator, Iterable<String>>, Predicate<String>, Predicate<String>> {
        private final Function<Iterable<String>, Predicate<String>> is;
        private final Function<Iterable<String>, Predicate<String>> not;

        IsAndNot(Function<Iterable<String>, Predicate<String>> is, Function<Iterable<String>, Predicate<String>> not) {
            this.is = is;
            this.not = not;
        }

        public Predicate<String> apply(Pair<StreamsFilterType.Operator, Iterable<String>> filter, Predicate<String> predicate) {
            switch ((StreamsFilterType.Operator)filter.first()) {
                case IS: {
                    return predicate.and(this.is.apply((Iterable)filter.second()));
                }
                case NOT: {
                    return predicate.and(this.not.apply((Iterable<String>)ImmutableSet.copyOf((Iterable)((Iterable)filter.second()))));
                }
            }
            return predicate;
        }
    }

    @Deprecated
    private static enum IsIn implements Function<Iterable<String>, Predicate<String>>
    {
        INSTANCE;


        @Override
        public Predicate<String> apply(Iterable<String> xs) {
            return el -> Iterables.contains((Iterable)xs, (Object)el);
        }
    }

    @Deprecated
    private static enum NotIn implements Function<Iterable<String>, Predicate<String>>
    {
        INSTANCE;


        @Override
        public Predicate<String> apply(Iterable<String> xs) {
            return IsIn.INSTANCE.apply(xs).negate();
        }
    }

    private static final class AnyInUsers
    implements Predicate<Iterable<String>> {
        private final Predicate<String> inUsers;

        public AnyInUsers(ActivityRequest request) {
            this.inUsers = Filters.inUsers(request);
        }

        @Override
        public boolean test(Iterable<String> users) {
            return StreamSupport.stream(users.spliterator(), false).anyMatch(this.inUsers);
        }
    }

    private static final class NotInUsers
    implements Predicate<Iterable<String>> {
        private final Iterable<String> nottedUsers;

        public NotInUsers(ActivityRequest request) {
            this.nottedUsers = Filters.getAllValues(StreamsFilterType.Operator.NOT, request.getStandardFiltersMap().getOrDefault(StandardStreamsFilterOption.USER.getKey(), Collections.emptyList()));
        }

        @Override
        public boolean test(Iterable<String> users) {
            return Sets.intersection((Set)ImmutableSet.copyOf(this.nottedUsers), (Set)ImmutableSet.copyOf(users)).isEmpty();
        }
    }

    private static final class InActivities
    implements Predicate<Pair<ActivityObjectType, ActivityVerb>> {
        private final Predicate<String> inActivities = Filters.isAndNot(activities)::test;

        public InActivities(Collection<Pair<StreamsFilterType.Operator, Iterable<String>>> activities) {
        }

        @Override
        public boolean test(Pair<ActivityObjectType, ActivityVerb> activity) {
            return this.inActivities.test(((ActivityObjectType)activity.first()).key() + ":" + ((ActivityVerb)activity.second()).key());
        }
    }

    private static final class InOptionActivities
    implements Predicate<Option<Pair<ActivityObjectType, ActivityVerb>>> {
        private final Predicate<String> inActivities = Filters.isAndNot(activities)::test;

        public InOptionActivities(Collection<Pair<StreamsFilterType.Operator, Iterable<String>>> activities) {
        }

        @Override
        public boolean test(Option<Pair<ActivityObjectType, ActivityVerb>> activity) {
            Iterator iterator = activity.iterator();
            if (iterator.hasNext()) {
                Pair activityPair = (Pair)iterator.next();
                return this.inActivities.test(((ActivityObjectType)activityPair.first()).key() + ":" + ((ActivityVerb)activityPair.second()).key());
            }
            return false;
        }

        public String toString() {
            return String.format("inOptionActivities(%s)", this.inActivities);
        }
    }

    private static final class EntriesInActivities
    implements Predicate<StreamsEntry> {
        private final Predicate<Pair<ActivityObjectType, ActivityVerb>> inActivities;

        public EntriesInActivities(Collection<Pair<StreamsFilterType.Operator, Iterable<String>>> activities) {
            this.inActivities = new InActivities(activities);
        }

        @Override
        public boolean test(StreamsEntry entry) {
            ActivityVerb verb = entry.getVerb();
            return StreamSupport.stream(ActivityObjectTypes.getActivityObjectTypes((Iterable)entry.getActivityObjects()).spliterator(), false).map(activityObjectType -> Pair.pair((Object)activityObjectType, (Object)verb)).anyMatch(this.inActivities);
        }
    }

    @Deprecated
    private static enum ContainsDate implements Function2<Pair<StreamsFilterType.Operator, Iterable<String>>, Predicate<Date>, Predicate<Date>>
    {
        INSTANCE;


        public Predicate<Date> apply(Pair<StreamsFilterType.Operator, Iterable<String>> filter, Predicate<Date> predicate) {
            List dates = StreamSupport.stream(((Iterable)filter.second()).spliterator(), false).map(Filters::toDate).collect(Collectors.toList());
            switch ((StreamsFilterType.Operator)filter.first()) {
                case BEFORE: {
                    return predicate.and(dates.stream().map(ToBeforePredicate.INSTANCE).reduce((Predicate<Date>)Predicates.alwaysFalse(), Predicate::or));
                }
                case AFTER: {
                    return predicate.and(dates.stream().map(ToAfterPredicate.INSTANCE).reduce((Predicate<Date>)Predicates.alwaysFalse(), Predicate::or));
                }
                case BETWEEN: {
                    Stream<Pair<Date, Date>> ranges = StreamSupport.stream(Pairs.mkPairs(dates).spliterator(), false);
                    return predicate.and(ranges.map(ToBetweenPredicate.INSTANCE).reduce((Predicate<Date>)Predicates.alwaysFalse(), Predicate::or));
                }
            }
            return predicate;
        }
    }

    private static enum ExtractIsAndNotValues implements BiFunction<Pair<StreamsFilterType.Operator, Iterable<String>>, Pair<Set<String>, Set<String>>, Pair<Set<String>, Set<String>>>
    {
        INSTANCE;


        @Override
        public Pair<Set<String>, Set<String>> apply(Pair<StreamsFilterType.Operator, Iterable<String>> current, Pair<Set<String>, Set<String>> intermediate) {
            switch ((StreamsFilterType.Operator)current.first()) {
                case IS: {
                    return Pair.pair((Object)Sets.union((Set)((Set)intermediate.first()), (Set)ImmutableSet.copyOf((Iterable)((Iterable)current.second()))), (Object)((Set)intermediate.second()));
                }
                case NOT: {
                    return Pair.pair((Object)((Set)intermediate.first()), (Object)Sets.union((Set)((Set)intermediate.second()), (Set)ImmutableSet.copyOf((Iterable)((Iterable)current.second()))));
                }
            }
            return intermediate;
        }
    }

    private static final class WithOperator
    implements Predicate<Pair<StreamsFilterType.Operator, Iterable<String>>> {
        private final StreamsFilterType.Operator op;

        public WithOperator(StreamsFilterType.Operator op) {
            this.op = op;
        }

        @Override
        public boolean test(Pair<StreamsFilterType.Operator, Iterable<String>> input) {
            return ((StreamsFilterType.Operator)input.first()).equals((Object)this.op);
        }
    }

    private static enum ToBetweenPredicate implements Function<Pair<Date, Date>, Predicate<Date>>
    {
        INSTANCE;


        @Override
        public Predicate<Date> apply(Pair<Date, Date> range) {
            return new BetweenPredicate(range);
        }

        private static final class BetweenPredicate
        implements Predicate<Date> {
            private final Pair<Date, Date> range;

            public BetweenPredicate(Pair<Date, Date> range) {
                this.range = range;
            }

            @Override
            public boolean test(Date input) {
                return input.after((Date)this.range.first()) && input.before((Date)this.range.second());
            }
        }
    }

    private static enum ToAfterPredicate implements Function<Date, Predicate<Date>>
    {
        INSTANCE;


        @Override
        public Predicate<Date> apply(Date date) {
            return new AfterPredicate(date);
        }

        private static final class AfterPredicate
        implements Predicate<Date> {
            private final Date date;

            public AfterPredicate(Date date) {
                this.date = date;
            }

            @Override
            public boolean test(Date input) {
                return input.after(this.date);
            }
        }
    }

    private static enum ToBeforePredicate implements Function<Date, Predicate<Date>>
    {
        INSTANCE;


        @Override
        public Predicate<Date> apply(Date date) {
            return new BeforePredicate(date);
        }

        private static final class BeforePredicate
        implements Predicate<Date> {
            private final Date date;

            public BeforePredicate(Date date) {
                this.date = date;
            }

            @Override
            public boolean test(Date input) {
                return input.before(this.date);
            }
        }
    }
}

