/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SHA256NativeDigest
implements SavableDigest {
    private final CryptoServicePurpose purpose;
    private DigestRefWrapper nativeRef = null;

    SHA256NativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this.purpose = cryptoServicePurpose;
        this.nativeRef = new DigestRefWrapper(SHA256NativeDigest.makeNative());
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    SHA256NativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    SHA256NativeDigest(SHA256NativeDigest sHA256NativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHA256NativeDigest.getEncodedState();
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SHA256NativeDigest restoreState(byte[] byArray, int n) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
            return this;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDigestSize() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return SHA256NativeDigest.getDigestSize(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte by) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.update(this.nativeRef.getReference(), by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return SHA256NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.reset(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByteLength() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return SHA256NativeDigest.getByteLength(this.nativeRef.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memoable copy() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            return new SHA256NativeDigest(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(Memoable memoable) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest sHA256NativeDigest2 = (SHA256NativeDigest)memoable;
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA256NativeDigest2.getEncodedState(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncodedState() {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            int n = SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
            byte[] byArray = new byte[n];
            SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreFullState(byte[] byArray, int n) {
        SHA256NativeDigest sHA256NativeDigest = this;
        synchronized (sHA256NativeDigest) {
            SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        }
    }

    public String toString() {
        return "SHA256[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, 256, this.purpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHA256");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA256NativeDigest.destroy(l);
        }
    }
}

